/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import flex.messaging.FlexContext;
import flex.messaging.log.Log;
import flex.messaging.security.AppServerLoginCommand;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

public class WebSphereLoginCommand
extends AppServerLoginCommand {
    public Principal doAuthentication(String username, Object credentials) {
        Object principal;
        block6: {
            principal = null;
            try {
                ContextManager contextManager;
                Subject subject;
                String password = this.extractPassword(credentials);
                if (password != null && (subject = (contextManager = ContextManagerFactory.getInstance()).login(contextManager.getDefaultRealm(), username, password)) != null) {
                    contextManager.setCallerSubject(subject);
                    principal = new WSLCPrincipal(username, contextManager, subject);
                }
            }
            catch (WSLoginFailedException wsLoginFailedException) {
                if (Log.isDebug()) {
                    Log.getLogger((String)"Security").debug("WebSphereLoginCommand#doAuthentication() failed: " + wsLoginFailedException.toString(), (Throwable)wsLoginFailedException);
                }
            }
            catch (WSSecurityException wsSecurityException) {
                if (!Log.isDebug()) break block6;
                Log.getLogger((String)"Security").debug("WebSphereLoginCommand#doAuthentication() failed: " + wsSecurityException.toString(), (Throwable)wsSecurityException);
            }
        }
        if (Log.isDebug() && principal != null) {
            Log.getLogger((String)"Security").debug("WebSphereLoginCommand#doAuthentication(). Principal: " + principal + ", Principal class: " + principal.getClass().getName() + ", Principal identity: " + System.identityHashCode(principal));
        }
        return principal;
    }

    public boolean doAuthorization(Principal principal, List roles) {
        if (principal == null) {
            return false;
        }
        if (Log.isDebug()) {
            Log.getLogger((String)"Security").debug("WebSphereLoginCommand#doAuthorization(). Principal: " + principal + ", Principal class: " + principal.getClass().getName() + ", Principal identity: " + System.identityHashCode(principal));
        }
        if (principal instanceof WSLCPrincipal) {
            ContextManager contextManager = ((WSLCPrincipal)principal).getContextManager();
            UserRegistry registry = contextManager.getRegistry(contextManager.getDefaultRealm());
            try {
                ArrayList groups = new ArrayList(registry.getGroupsForUser(principal.getName()));
                groups.retainAll(roles);
                if (groups.size() > 0) {
                    ContextManagerFactory.getInstance().setCallerSubject(((WSLCPrincipal)principal).getSubject());
                }
                return groups.size() > 0;
            }
            catch (Exception e) {}
        } else {
            HttpServletRequest request = FlexContext.getHttpRequest();
            Iterator iter = roles.iterator();
            while (iter.hasNext()) {
                if (!request.isUserInRole((String)iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean logout(Principal principal) {
        return true;
    }

    private class WSLCPrincipal
    implements Principal {
        private String username;
        private ContextManager contextManager;
        private Subject subject;

        public WSLCPrincipal(String username, ContextManager contextManager, Subject subject) {
            this.username = username;
            this.contextManager = contextManager;
            this.subject = subject;
        }

        public String getName() {
            return this.username;
        }

        public ContextManager getContextManager() {
            return this.contextManager;
        }

        public Subject getSubject() {
            return this.subject;
        }
    }
}

