import { type XmlOptions } from "./xml.common.js";
/**
 * Converts given JSON object to XML string
 * @param obj - JSON object to be converted into XML string
 * @param opts - Options that govern the XML building of given JSON object
 * `rootName` indicates the name of the root element in the resulting XML
 */
export declare function stringifyXML(obj: unknown, opts?: XmlOptions): string;
/**
 * Converts given XML string into JSON
 * @param str - String containing the XML content to be parsed into JSON
 * @param opts - Options that govern the parsing of given xml string
 * `includeRoot` indicates whether the root element is to be included or not in the output
 */
export declare function parseXML(str: string, opts?: XmlOptions): Promise<any>;
//# sourceMappingURL=xml.d.ts.map