/**
 * Creates an {@link AccountSasServices} from the specified services string. This method will throw an
 * Error if it encounters a character that does not correspond to a valid service.
 *
 * @param services -
 */
export declare function accountSasServicesFromString(services: string): AccountSasServices;
/**
 * Converts the given services to a string.
 *
 */
export declare function accountSasServicesToString(services?: AccountSasServices): string;
/**
 * Services that the SAS token can access
 */
export interface AccountSasServices {
    /**
     * Permission to access blob resources granted.
     */
    blob?: boolean;
    /**
     * Permission to access file resources granted.
     */
    file?: boolean;
    /**
     * Permission to access queue resources granted.
     */
    queue?: boolean;
    /**
     * Permission to access table resources granted.
     */
    table?: boolean;
}
//# sourceMappingURL=accountSasServices.d.ts.map