/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * TableSASSignatureValues is used to help generating SAS tokens for tables.
 */
import type { SasIPRange } from "./sasIPRange.js";
import type { SasProtocol } from "./sasQueryParameters.js";
import { SasQueryParameters } from "./sasQueryParameters.js";
import type { TableSasPermissions } from "./tableSasPermisions.js";
import type { NamedKeyCredential } from "@azure/core-auth";
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * TableSASSignatureValues is used to help generating Table service SAS tokens for tables
 */
export interface TableSasSignatureValues {
    /**
     * The version of the service this SAS will target. If not specified, it will default to the version targeted by the
     * library.
     */
    version?: string;
    /**
     * Optional. SAS protocols, HTTPS only or HTTPSandHTTP
     */
    protocol?: SasProtocol;
    /**
     * Optional. When the SAS will take effect.
     */
    startsOn?: Date;
    /**
     * Optional. If identifier is not provided has a default value of one hour from the time the token is generated.
     * The time after which the SAS will no longer work.
     */
    expiresOn?: Date;
    /**
     * Optional. If identifier is not provided has a default value of "read"
     * Please refer to {@link TableSasPermissions} depending on the resource
     * being accessed for help constructing the permissions string.
     */
    permissions?: TableSasPermissions;
    /**
     * Optional. IP ranges allowed in this SAS.
     */
    ipRange?: SasIPRange;
    /**
     * Optional. The name of the access policy on the container this SAS references if any.
     *
     * @see https://learn.microsoft.com/en-us/rest/api/storageservices/establishing-a-stored-access-policy
     */
    identifier?: string;
    /**
     * Define the start of a Partition Key range
     * Table queries will only return results that are within the range, and attempts to use the shared access signature to add, update, or delete entities outside this range will fail.
     * If startPartitionKey equals endPartitionKey the shared access signature only authorizes access to entities in one partition in the table.
     * If startPartitionKey equals endPartitionKey and startRowKey equals endRowKey, the shared access signature can only access one entity in one partition
     */
    startPartitionKey?: string;
    /**
     * Define the end of a Partition Key range
     * Table queries will only return results that are within the range, and attempts to use the shared access signature to add, update, or delete entities outside this range will fail.
     * If startPartitionKey equals endPartitionKey the shared access signature only authorizes access to entities in one partition in the table.
     * If startPartitionKey equals endPartitionKey and startRowKey equals endRowKey, the shared access signature can only access one entity in one partition
     */
    endPartitionKey?: string;
    /**
     * Define the start of a Row Key range
     * Table queries will only return results that are within the range, and attempts to use the shared access signature to add, update, or delete entities outside this range will fail.
     * If startPartitionKey equals endPartitionKey the shared access signature only authorizes access to entities in one partition in the table.
     * If startPartitionKey equals endPartitionKey and startRowKey equals endRowKey, the shared access signature can only access one entity in one partition
     */
    startRowKey?: string;
    /**
     * Define the end of a Row Key range
     * Table queries will only return results that are within the range, and attempts to use the shared access signature to add, update, or delete entities outside this range will fail.
     * If startPartitionKey equals endPartitionKey the shared access signature only authorizes access to entities in one partition in the table.
     * If startPartitionKey equals endPartitionKey and startRowKey equals endRowKey, the shared access signature can only access one entity in one partition
     */
    endRowKey?: string;
}
/**
 * ONLY AVAILABLE IN NODE.JS RUNTIME.
 *
 * Creates an instance of SASQueryParameters.
 *
 * **Note**: When identifier is not provided, permissions has a default value of "read" and expiresOn of one hour from the time the token is generated.
 */
export declare function generateTableSasQueryParameters(tableName: string, credential: NamedKeyCredential, tableSasSignatureValues: TableSasSignatureValues): SasQueryParameters;
//# sourceMappingURL=tableSasSignatureValues.d.ts.map