"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.tablesSecondaryEndpointPolicy = exports.SecondaryLocationHeaderName = exports.tablesSecondaryEndpointPolicyName = void 0;
exports.injectSecondaryEndpointHeader = injectSecondaryEndpointHeader;
/**
 * The programmatic identifier of the tablesSecondaryEndpointPolicy.
 */
exports.tablesSecondaryEndpointPolicyName = "tablesSecondaryEndpointPolicy";
exports.SecondaryLocationHeaderName = "tables-secondary-endpoint";
const SecondaryLocationAccountSuffix = "-secondary";
/**
 * Policy that would replace the Primary Endpoint with the secondary endpoint
 * when the `tables-secondary-endpoint` is set in the request
 */
exports.tablesSecondaryEndpointPolicy = {
    name: exports.tablesSecondaryEndpointPolicyName,
    sendRequest: async (req, next) => {
        // Only replace the URL if the SecondaryLocationHeader is set
        if (req.headers.get(exports.SecondaryLocationHeaderName)) {
            // Since the header is for internal use only, clean it up.
            req.headers.delete(exports.SecondaryLocationHeaderName);
            // Calculate and update the secondary url
            req.url = getSecondaryUrlFromPrimary(req.url);
        }
        return next(req);
    },
};
/**
 * Utility function that injects the SecondaryEndpointHeader into an operation options
 */
function injectSecondaryEndpointHeader(options) {
    var _a;
    const headerToInject = { [exports.SecondaryLocationHeaderName]: "true" };
    return Object.assign(Object.assign({}, options), { requestOptions: Object.assign(Object.assign({}, options.requestOptions), { customHeaders: Object.assign(Object.assign({}, (_a = options.requestOptions) === null || _a === void 0 ? void 0 : _a.customHeaders), headerToInject) }) });
}
/**
 * Utility function that calculates the secondary URL for a table instance given the primary URL.
 */
function getSecondaryUrlFromPrimary(primaryUrl) {
    const parsedPrimaryUrl = new URL(primaryUrl);
    const host = parsedPrimaryUrl.hostname.split(".");
    if (host.length > 1) {
        host[0] = `${host[0]}${SecondaryLocationAccountSuffix}`;
    }
    parsedPrimaryUrl.hostname = host.join(".");
    return parsedPrimaryUrl.toString();
}
//# sourceMappingURL=secondaryEndpointPolicy.js.map