"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.apiVersionPolicy = exports.apiVersionPolicyName = void 0;
/**
 * Name of the apiVersion Policy
 * @internal
 */
exports.apiVersionPolicyName = "apiVersionPolicy";
/**
 * Pipeline policy that enables users to override the default api version
 * @internal
 */
const apiVersionPolicy = (apiVersion) => {
    return {
        name: exports.apiVersionPolicyName,
        sendRequest: async (req, next) => {
            req.headers.set("x-ms-version", apiVersion);
            return next(req);
        },
    };
};
exports.apiVersionPolicy = apiVersionPolicy;
//# sourceMappingURL=apiVersionPolicy.js.map