"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeHMACSHA256 = computeHMACSHA256;
const node_crypto_1 = require("node:crypto");
function computeHMACSHA256(stringToSign, accountKey) {
    const key = Buffer.from(accountKey, "base64");
    return (0, node_crypto_1.createHmac)("sha256", key).update(stringToSign, "utf8").digest("base64");
}
//# sourceMappingURL=computeHMACSHA256.js.map