import type { OperationOptions, OperationRequest } from "@azure/core-client";
import type { PipelineResponse } from "@azure/core-rest-pipeline";
import type { AzureLogger } from "@azure/logger";
import type { TableServiceError } from "../generated/index.js";
export type TableServiceErrorResponse = PipelineResponse & {
    /**
     * The parsed HTTP response headers.
     */
    parsedHeaders?: Record<string, unknown>;
    /**
     * The response body as parsed JSON or XML.
     */
    parsedBody: TableServiceError;
    /**
     * The request that generated the response.
     */
    request: OperationRequest;
};
export declare function handleTableAlreadyExists(error: unknown, options?: OperationOptions & {
    tableName?: string;
    logger?: AzureLogger;
}): void;
//# sourceMappingURL=errorHelpers.d.ts.map