/**
 * Creates an {@link accountSasResourceTypesFromString} from the specified resource types string. This method will throw an
 * Error if it encounters a character that does not correspond to a valid resource type.
 *
 * @param resourceTypes -
 */
export declare function accountSasResourceTypesFromString(resourceTypes: string): AccountSasResourceTypes;
/**
 * Converts the given resource types to a string.
 *
 * @see https://learn.microsoft.com/en-us/rest/api/storageservices/constructing-an-account-sas
 *
 */
export declare function accountSasResourceTypesToString(resourceTypes: AccountSasResourceTypes): string;
/**
 * Represents the Resources that are accessible by the SAS token
 */
export interface AccountSasResourceTypes {
    /**
     * Permission to access service level APIs granted.
     */
    service?: boolean;
    /**
     * Permission to access container level APIs (Blob Containers, Tables, Queues, File Shares) granted.
     */
    container?: boolean;
    /**
     * Permission to access object level APIs (Blobs, Table Entities, Queue Messages, Files) granted.
     */
    object?: boolean;
}
//# sourceMappingURL=accountSasResourceTypes.d.ts.map