import type { StorageClient as StorageClientContext } from "./generated/src/index.js";
import type { Pipeline } from "./Pipeline.js";
import type { OperationTracingOptions } from "@azure/core-tracing";
import type { AnonymousCredential } from "@azure/storage-common";
import type { StorageSharedKeyCredential } from "@azure/storage-common";
import type { TokenCredential } from "@azure/core-auth";
/**
 * An interface for options common to every remote operation.
 */
export interface CommonOptions {
    tracingOptions?: OperationTracingOptions;
}
/**
 * A StorageClient represents a base client class for ServiceClient, ContainerClient and etc.
 */
export declare abstract class StorageClient {
    /**
     * URL string value.
     */
    readonly url: string;
    readonly accountName: string;
    /**
     * Request policy pipeline.
     *
     * @internal
     */
    protected readonly pipeline: Pipeline;
    /**
     * Credential in the pipeline to authenticate requests to the service, such as AnonymousCredential, StorageSharedKeyCredential.
     * Initialized to an AnonymousCredential if not able to retrieve it from the pipeline.
     *
     * @internal
     */
    protected readonly credential: StorageSharedKeyCredential | AnonymousCredential | TokenCredential;
    /**
     * StorageClient is a reference to protocol layer operations entry, which is
     * generated by AutoRest generator.
     */
    protected readonly storageClientContext: StorageClientContext;
    /**
     * Creates an instance of StorageClient.
     * @param url -
     * @param pipeline -
     */
    protected constructor(url: string, pipeline: Pipeline);
}
//# sourceMappingURL=StorageClient.d.ts.map