"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClient = void 0;
const StorageContextClient_js_1 = require("./StorageContextClient.js");
const Pipeline_js_1 = require("./Pipeline.js");
const utils_common_js_1 = require("./utils/utils.common.js");
/**
 * A StorageClient represents a base client class for ServiceClient, ContainerClient and etc.
 */
class StorageClient {
    /**
     * URL string value.
     */
    url;
    accountName;
    /**
     * Request policy pipeline.
     *
     * @internal
     */
    pipeline;
    /**
     * Credential in the pipeline to authenticate requests to the service, such as AnonymousCredential, StorageSharedKeyCredential.
     * Initialized to an AnonymousCredential if not able to retrieve it from the pipeline.
     *
     * @internal
     */
    credential;
    /**
     * StorageClient is a reference to protocol layer operations entry, which is
     * generated by AutoRest generator.
     */
    storageClientContext;
    /**
     * Creates an instance of StorageClient.
     * @param url -
     * @param pipeline -
     */
    constructor(url, pipeline) {
        // URL should be encoded and only once, protocol layer shouldn't encode URL again
        this.url = (0, utils_common_js_1.escapeURLPath)(url);
        this.accountName = (0, utils_common_js_1.getAccountNameFromUrl)(url);
        this.pipeline = pipeline;
        this.storageClientContext = new StorageContextClient_js_1.StorageContextClient(this.url, (0, Pipeline_js_1.getCoreClientOptions)(pipeline));
        // Remove the default content-type in generated code of StorageClientContext
        const storageClientContext = this.storageClientContext;
        if (storageClientContext.requestContentType) {
            storageClientContext.requestContentType = undefined;
        }
        const credential = (0, Pipeline_js_1.getCredentialFromPipeline)(pipeline);
        this.credential = credential;
    }
}
exports.StorageClient = StorageClient;
//# sourceMappingURL=StorageClient.js.map