"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClient = void 0;
const tslib_1 = require("tslib");
const coreHttpCompat = tslib_1.__importStar(require("@azure/core-http-compat"));
const index_js_1 = require("./operations/index.js");
class StorageClient extends coreHttpCompat.ExtendedServiceClient {
    url;
    version;
    fileRangeWriteFromUrl;
    /**
     * Initializes a new instance of the StorageClient class.
     * @param url The URL of the service account, share, directory or file that is the target of the
     *            desired operation.
     * @param options The parameter options
     */
    constructor(url, options) {
        if (url === undefined) {
            throw new Error("'url' cannot be null");
        }
        // Initializing default values for options
        if (!options) {
            options = {};
        }
        const defaults = {
            requestContentType: "application/json; charset=utf-8"
        };
        const packageDetails = `azsdk-js-azure-storage-file-share/12.28.0`;
        const userAgentPrefix = options.userAgentOptions && options.userAgentOptions.userAgentPrefix
            ? `${options.userAgentOptions.userAgentPrefix} ${packageDetails}`
            : `${packageDetails}`;
        const optionsWithDefaults = {
            ...defaults,
            ...options,
            userAgentOptions: {
                userAgentPrefix
            },
            endpoint: options.endpoint ?? options.baseUri ?? "{url}"
        };
        super(optionsWithDefaults);
        // Parameter assignments
        this.url = url;
        // Assigning values to Constant parameters
        this.version = options.version || "2025-07-05";
        this.fileRangeWriteFromUrl = options.fileRangeWriteFromUrl || "update";
        this.service = new index_js_1.ServiceImpl(this);
        this.share = new index_js_1.ShareImpl(this);
        this.directory = new index_js_1.DirectoryImpl(this);
        this.file = new index_js_1.FileImpl(this);
    }
    service;
    share;
    directory;
    file;
}
exports.StorageClient = StorageClient;
//# sourceMappingURL=storageClient.js.map