"use strict";
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageContextClient = void 0;
const index_js_1 = require("./generated/src/index.js");
/**
 * @internal
 */
class StorageContextClient extends index_js_1.StorageClient {
    async sendOperationRequest(operationArguments, operationSpec) {
        const operationSpecToSend = { ...operationSpec };
        if (operationSpecToSend.path === "/{queueName}" ||
            operationSpecToSend.path === "/{queueName}/messages" ||
            operationSpecToSend.path === "/{queueName}/messages/{messageid}") {
            operationSpecToSend.path = "";
        }
        return super.sendOperationRequest(operationArguments, operationSpecToSend);
    }
}
exports.StorageContextClient = StorageContextClient;
//# sourceMappingURL=StorageContextClient.js.map