"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.visibilityTimeout1 = exports.popReceipt = exports.queueMessage1 = exports.peekonly = exports.messageTimeToLive = exports.queueMessage = exports.visibilityTimeout = exports.numberOfMessages = exports.queueAcl = exports.comp4 = exports.comp3 = exports.metadata = exports.include = exports.maxPageSize = exports.marker = exports.prefix = exports.comp2 = exports.comp1 = exports.accept1 = exports.requestId = exports.version = exports.timeoutInSeconds = exports.comp = exports.restype = exports.url = exports.accept = exports.properties = exports.contentType = void 0;
const mappers_js_1 = require("../models/mappers.js");
exports.contentType = {
    parameterPath: ["options", "contentType"],
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Content-Type",
        type: {
            name: "String"
        }
    }
};
exports.properties = {
    parameterPath: "properties",
    mapper: mappers_js_1.QueueServiceProperties
};
exports.accept = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
exports.url = {
    parameterPath: "url",
    mapper: {
        serializedName: "url",
        required: true,
        xmlName: "url",
        type: {
            name: "String"
        }
    },
    skipEncoding: true
};
exports.restype = {
    parameterPath: "restype",
    mapper: {
        defaultValue: "service",
        isConstant: true,
        serializedName: "restype",
        type: {
            name: "String"
        }
    }
};
exports.comp = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "properties",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
exports.timeoutInSeconds = {
    parameterPath: ["options", "timeoutInSeconds"],
    mapper: {
        constraints: {
            InclusiveMinimum: 0
        },
        serializedName: "timeout",
        xmlName: "timeout",
        type: {
            name: "Number"
        }
    }
};
exports.version = {
    parameterPath: "version",
    mapper: {
        defaultValue: "2025-07-05",
        isConstant: true,
        serializedName: "x-ms-version",
        type: {
            name: "String"
        }
    }
};
exports.requestId = {
    parameterPath: ["options", "requestId"],
    mapper: {
        serializedName: "x-ms-client-request-id",
        xmlName: "x-ms-client-request-id",
        type: {
            name: "String"
        }
    }
};
exports.accept1 = {
    parameterPath: "accept",
    mapper: {
        defaultValue: "application/xml",
        isConstant: true,
        serializedName: "Accept",
        type: {
            name: "String"
        }
    }
};
exports.comp1 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "stats",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
exports.comp2 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "list",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
exports.prefix = {
    parameterPath: ["options", "prefix"],
    mapper: {
        serializedName: "prefix",
        xmlName: "prefix",
        type: {
            name: "String"
        }
    }
};
exports.marker = {
    parameterPath: ["options", "marker"],
    mapper: {
        serializedName: "marker",
        xmlName: "marker",
        type: {
            name: "String"
        }
    }
};
exports.maxPageSize = {
    parameterPath: ["options", "maxPageSize"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "maxresults",
        xmlName: "maxresults",
        type: {
            name: "Number"
        }
    }
};
exports.include = {
    parameterPath: ["options", "include"],
    mapper: {
        serializedName: "include",
        xmlName: "include",
        xmlElementName: "ListQueuesIncludeType",
        type: {
            name: "Sequence",
            element: {
                defaultValue: "metadata",
                isConstant: true,
                type: {
                    name: "String"
                }
            }
        }
    },
    collectionFormat: "CSV"
};
exports.metadata = {
    parameterPath: ["options", "metadata"],
    mapper: {
        serializedName: "x-ms-meta",
        xmlName: "x-ms-meta",
        headerCollectionPrefix: "x-ms-meta-",
        type: {
            name: "Dictionary",
            value: { type: { name: "String" } }
        }
    }
};
exports.comp3 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "metadata",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
exports.comp4 = {
    parameterPath: "comp",
    mapper: {
        defaultValue: "acl",
        isConstant: true,
        serializedName: "comp",
        type: {
            name: "String"
        }
    }
};
exports.queueAcl = {
    parameterPath: ["options", "queueAcl"],
    mapper: {
        serializedName: "queueAcl",
        xmlName: "SignedIdentifiers",
        xmlIsWrapped: true,
        xmlElementName: "SignedIdentifier",
        type: {
            name: "Sequence",
            element: {
                type: {
                    name: "Composite",
                    className: "SignedIdentifier"
                }
            }
        }
    }
};
exports.numberOfMessages = {
    parameterPath: ["options", "numberOfMessages"],
    mapper: {
        constraints: {
            InclusiveMinimum: 1
        },
        serializedName: "numofmessages",
        xmlName: "numofmessages",
        type: {
            name: "Number"
        }
    }
};
exports.visibilityTimeout = {
    parameterPath: ["options", "visibilityTimeout"],
    mapper: {
        constraints: {
            InclusiveMaximum: 604800,
            InclusiveMinimum: 0
        },
        serializedName: "visibilitytimeout",
        xmlName: "visibilitytimeout",
        type: {
            name: "Number"
        }
    }
};
exports.queueMessage = {
    parameterPath: "queueMessage",
    mapper: mappers_js_1.QueueMessage
};
exports.messageTimeToLive = {
    parameterPath: ["options", "messageTimeToLive"],
    mapper: {
        constraints: {
            InclusiveMinimum: -1
        },
        serializedName: "messagettl",
        xmlName: "messagettl",
        type: {
            name: "Number"
        }
    }
};
exports.peekonly = {
    parameterPath: "peekonly",
    mapper: {
        defaultValue: "true",
        isConstant: true,
        serializedName: "peekonly",
        type: {
            name: "String"
        }
    }
};
exports.queueMessage1 = {
    parameterPath: ["options", "queueMessage"],
    mapper: mappers_js_1.QueueMessage
};
exports.popReceipt = {
    parameterPath: "popReceipt",
    mapper: {
        serializedName: "popreceipt",
        required: true,
        xmlName: "popreceipt",
        type: {
            name: "String"
        }
    }
};
exports.visibilityTimeout1 = {
    parameterPath: "visibilityTimeout",
    mapper: {
        constraints: {
            InclusiveMaximum: 604800,
            InclusiveMinimum: 0
        },
        serializedName: "visibilitytimeout",
        required: true,
        xmlName: "visibilitytimeout",
        type: {
            name: "Number"
        }
    }
};
//# sourceMappingURL=parameters.js.map