# FHTTP Kit by Xianur0
# Copyright (C) 2011 Oscar García López (http://hackingtelevision.blogspot.com) 
#  
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#   
#    xianur0.null@gmail.com
#    http://hackingtelevision.blogspot.com/

package ping;
$idioma = main::mods("--lang");

sub grafico {
	my $threadproxy;
	my $ventana = Gtk2::Window->new('toplevel');
	$ventana->set_title("HTPing - Ping Over HTTP");
	$ventana->set_default_icon_from_file("icono.jpg");
	$imagen = Gtk2::Image->new_from_file("logo.png");
	$ventana->set_default_size(20, 00);
	$ventana->set_resizable(TRUE);
	$t1 = Gtk2::Label->new('URL: ');
	$t2 = Gtk2::Label->new(dic::fingerlabels($idioma,5).': ');
	$t3 = Gtk2::Label->new(dic::comunes($idioma,22).': ');
	$t4 = Gtk2::Label->new(dic::comunes($idioma,14).': ');
	$url = Gtk2::Entry->new();
	$paq = Gtk2::Entry->new();
	$tsleep = Gtk2::Entry->new();
	$method = Gtk2::Entry->new();
	$caja1 = Gtk2::HBox->new(1,0);
	$caja2 = Gtk2::HBox->new(1,0);
	$caja3 = Gtk2::HBox->new(1,0);
	$caja4 = Gtk2::HBox->new(1,0);
	$caja1->pack_start($t1,FALSE,FALSE,2);
	$caja1->pack_start($url,FALSE,FALSE,2);
	$caja2->pack_start($t2,FALSE,FALSE,2);
	$caja2->pack_start($paq,FALSE,FALSE,2);
	$caja3->pack_start($t3,FALSE,FALSE,2);
	$caja3->pack_start($tsleep,FALSE,FALSE,2);
	$caja4->pack_start($t4,FALSE,FALSE,2);
	$caja4->pack_start($method,FALSE,FALSE,2);
	$vbox = Gtk2::VBox->new(0, 0);
	$vbox->pack_start($imagen,FALSE,FALSE,2);
	$vbox->pack_start($caja1,FALSE,FALSE,2);
	$vbox->pack_start($caja2,FALSE,FALSE,2);
	$vbox->pack_start($caja3,FALSE,FALSE,2);
	$vbox->pack_start($caja4,FALSE,FALSE,2);
	my $vp = Gtk2::Viewport->new (undef,undef);
	$scrolled = Gtk2::ScrolledWindow->new();
	$scrolled->set_placement(GTK_CORNER_BOTTOM_RIGHT);
	$scrolled->add($vp);
	$area = Gtk2::Label->new($cadena);
	$vp->add($area);
	&main::share($area);
	$boton = Gtk2::Button->new(dic::fingerlabels($idioma,1));
	$boton->signal_connect('clicked' => sub {
		if($boton->get_label eq dic::fingerlabels($idioma,1)) {
			$boton->set_label(dic::fingerlabels($idioma,3));
			$threadproxy = threads->create('ping');
			sleep(2);
			if(!$threadproxy->is_running()) {
				$boton->set_label(dic::fingerlabels($idioma,1));
			}
		} else {
			$boton->set_label(dic::fingerlabels($idioma,1));
			$threadproxy->kill('KILL');
		}
	});
	$vbox->pack_start($boton,FALSE,FALSE,2);
	$vbox->pack_start($scrolled,FALSE,FALSE,2);
	$vbox->show;
	$ventana->add($vbox);
	$scrolled->set_placement(GTK_CORNER_BOTTOM_RIGHT);
	$ventana->show_all;
	Gtk2->main;
}

sub new {
	if(&main::mods("Gtk2") == 1) {
		grafico();
	} elsif($#ARGV > 1) {
		ping();
	} else {
		die(dic::comunes($idioma,0).": fhttp.pl 4 [url] [".dic::comunes($idioma,13)."] [".dic::comunes($idioma,14)."]\n");
	}
}


sub ping() {
	$SIG{'KILL'} = sub { print "Killed...\n"; threads->exit(); };
	my $lineaurl = $ARGV[1] || ((&main::mods("Gtk2") == 1) ? $url->get_text() : die("URL Invalida!\n"));
	die(dic::comunes($idioma,15)."!\n") if($lineaurl !~ /^http/);
	my $paquetes = $ARGV[2] || ((&main::mods("Gtk2") == 1) ? $paq->get_text() : 10);
	my $sleep = $ARGV[3] || ((&main::mods("Gtk2") == 1) ? $tsleep->get_text() : 0);
	my $metodo = $ARGV[4] || ((&main::mods("Gtk2") == 1) ? $method->get_text() : "GET");
	$scrolled->set_placement(GTK_CORNER_TOP_LEFT) if(&main::mods("Gtk2") == 1);
	my ($scheme,$host,$hosthead,$path,$puerto,$ssl) = tools::parseurl($lineaurl);
	$lineaurl .= "/" if($path eq "/" && $lineaurl !~ /\/$/);
	die(dic::comunes($idioma,16)."!\n") if($host eq "" || $puerto eq "" || $paquetes < 2);
	my $parser = parser->new();
	my $texto = "";
	my $seq = 0;
	$area->set_text("HTPing - Ping Over HTTP\n\n") if(&main::mods("Gtk2") == 1);
	print "HTPing - Ping Over HTTP\n\n";
	my $nreqs = 0;
	while(1) {
		my ($soportados,%estructuratmp) = $parser->soportados($lineaurl,$host,$puerto,$ssl,$paquetes,$metodo);
		die("No Keep-Alive!\n") if($soportados < 2);
		my $pre = -1;
		for($ina = 0; $ina < $soportados;$ina++) {
			print $estructuratmp{encabezados}[$ina]{"Date"}."\n";
			my ($dia,$mes,$anio,$hora,$horas,$minutos,$segundos,$segt1) = tools::dateparser($estructuratmp{encabezados}[$ina]{"Date"});
			if($segundos == 59) {

			}
			my $diff = ($segt1-$pre);
			$texto = ($seq." ".$host.":".$puerto." ".$ina."/".($soportados-1)." Time=".$diff." seg\n".$texto) if($pre >= 0);
			$pre = $segt1;
			$seq++;
		}
		$area->set_text("HTPing - Ping Over HTTP\n\n".$texto) if(&main::mods("Gtk2") == 1);
		print $texto;
		$nreqs++;
		sleep($sleep) if($sleep > 0);
	}
}

1;
