# FHTTP Kit by Xianur0
# Copyright (C) 2011 Oscar García López (http://hackingtelevision.blogspot.com) 
#  
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#   
#    xianur0.null@gmail.com
#    http://hackingtelevision.blogspot.com/

package proxy;
use Switch;
use lib("proxymodulos");
use proxymodulos;
use lib("tools");
use tools;
use POSIX ':signal_h';
$idioma = main::mods("--lang");
my $threadproxy;
my $modulos = new proxymodulos();
my $hilovivo :shared = 0;
#our $lockleer :shared = 0;
my $ventanaexistente :shared = 0;
my $puertoescucha;
my $eliminarssl :shared;
$eliminarssl = 1;
my $nivelofuscacion = 0;
my $headescapado = 0;
my $tabulaciones = 0;
our $mostrar;
my $botone;
my $botone2;
my $text1;
my $text2;
if(&main::mods("Gtk2") == 1) {
	$mostrar = Gtk2::Label->new();
	$botone = Gtk2::Button->new(dic::fingerlabels($idioma,7));
	$botone2 = Gtk2::Button->new(dic::fingerlabels($idioma,7));
	$text1 = Gtk2::TextView->new();
	$text2 = Gtk2::TextView->new();
	&main::share($mostrar);
	&main::share($botone);
	&main::share($botone2);
	&main::share($text1);
	&main::share($text2);
}
my $conteo : shared = 0;
my $desactivado : shared = 0;
my $desactivado2 : shared = 0;
my $sendnav : shared = 0;
my $sendserv : shared = 0;

sub decode {
	my ($u,$o,$cadena) = @_;
	$u =~ s/&gt;/>/g;
	$u =~ s/&lt;/</g;
	$u =~ s/[^\\]\\n/\n/g;
	$u =~ s/[^\\]\\t/\t/g;
	$u =~ s/[^\\]\\r/\r/g;
	$u =~ s/\\\\n/\\n/g;
	$u =~ s/\\\\t/\\t/g;
	$u =~ s/\\\\r/\\r/g;
	$o =~ s/&gt;/>/g;
	$o =~ s/&lt;/</g;
	$o =~ s/[^\\]\\n/\n/g;
	$o =~ s/[^\\]\\r/\r/g;
	$o =~ s/[^\\]\\t/\t/g;
	$o =~ s/\\\\n/\\n/g;
	$o =~ s/\\\\t/\\t/g;
	$o =~ s/\\\\r/\\r/g;
	$o =~ s/\s*<!--(.*)$//g;
	my @salidas = ($cadena =~ /$u/i);
	$contador = 1;
	foreach $sal (@salidas) {
		$o =~ s/[^\\]\$$contador/$sal/g;
		$contador++;
	}
	$o =~ s/\\\$/\$/g;
	return ($u,$o);
}

sub hiloproxy {
	my $semilla = 0;
	$nivelofuscacion = $ARGV[1] if($ARGV[1] ne "" && $ARGV[1] =~ /^\d+$/);
	if(&main::mods("Gtk2") == 1) {
		&main::share($mostrar);
		$nivelofuscacion = 0 if($radiobutton1->get_active);
		$nivelofuscacion = 1 if($radiobutton2->get_active);
		$nivelofuscacion = 2 if($radiobutton3->get_active);
		$nivelofuscacion = 3 if($radiobutton4->get_active);
		$mostrar->set_text(dic::comunes($idioma,23)."!\n") if($puerto->get_text !~ /^[\d]*$/ && $path ne "" && $ARGV[2] !~ /^\d+$/);
		$puertoescucha = $puerto->get_text;
		if($ssl->get_active) {
			$eliminarssl = 1;
		} else {$eliminarssl = 0;}
	}
	$puertoescucha = $ARGV[2] if($ARGV[2] ne "" && $ARGV[2] =~ /^\d+$/);
	$eliminarssl = $ARGV[3] if($ARGV[3] ne "" && $ARGV[3] =~ /^(1|0)$/);
	if($puertoescucha ne ""){
		$mostrar->set_text(dic::comunes($idioma,30)."!\n") if(&main::mods("Gtk2") == 1);
		if(&main::mods("IO::Socket::SSL") == 0 && $eliminarssl == 1) {
			die("\n[x]".dic::mensajes($idioma,21)."\n\n");
		}
		print "[-] No-SSL\n" if($eliminarssl == 1);
		print "[-] ".dic::comunes($idioma,24).": ".$puertoescucha."\n";
		print "[-] ".dic::comunes($idioma,25).": ".$nivelofuscacion."\n";
		my $listen_socket = IO::Socket::INET->new(LocalPort => $puertoescucha, Listen => 10, Proto => 'tcp', Reuse => 0);
		if(!$listen_socket) {
			$mostrar->set_text(dic::comunes($idioma,26)."! ".$@."\n") if(&main::mods("Gtk2") == 1);
			die(dic::comunes($idioma,26)."! ".$@."\n");
		}
		$mostrar->set_text(dic::comunes($idioma,27)."\n") if(&main::mods("Gtk2") == 1);
		while (my $connection = $listen_socket->accept){
			if($connection) {
				while($ventanaexistente == 1) {sleep(1);}
				threads->create('proxy',($connection,$semilla));
				$semilla++;
				$connection->close();
			}
		}
	}
}

sub comenzar {
	threads->create('hiloproxy');
	while($hilovivo == 1) {
		sleep(2);
	}
	threads->exit();
}

# Para advanced mode :D
sub control {
	my ($semilla,$respuesta,$id) = @_;
	if($id == 0) {
		$buffer = $text1->get_buffer;
		$buffer->set_text($respuesta);
	} else {
		$buffer = $text2->get_buffer;
		$buffer->set_text($respuesta);
	}
}


# parsear

sub leer {
	my ($servidor,$navegador,$controlado,$paqenv) = @_;
	my $linea = "";
	my $respuestasa = "";
	my @respuestas = ();
	my $respuestacompleta = "";
	my ($rheader,$rcrlf,$htmlcontenido) = ("","","");
	while($linea = <$servidor>) {
			$respuestasa .= $linea;
	}
	close($servidor) if($servidor);
	print "\n[-] ".dic::comunes($idioma,28)."!\n"  if(&main::mods("Cheat---verbose") > 0);
	if($nivelofuscacion >= 3){
		my $parser = parser->new();
		@respuestas = $parser->parsear($respuestasa);
		@respuestas = reverse(@respuestas);
		if($respuestas[1] eq "") {
			print "500!\n";
			print $navegador "HTTP/1.1 500 Internal Server Error\r\nServer: fhttp-By-Xianur0\r\nContent-Type: text/html\r\nContent-Length: 140\r\n\r\n<html>\r\n<head>\r\n<title>Server Error</title>\r\n</head>\r\n<body>\r\nLo lamento, el servidor no parese soporta conexiones vivas :(\r\n</body>\r\n</html>\r\n\r\n";
			close($navegador);
			return;
		}
		$respuestacompleta = $respuestas[0];
	} else {
		$respuestacompleta = $respuestasa;
	}
	$respuestacompleta =~ s/^[\r\n]+//g;
	print $respuestacompleta if(&main::mods("Cheat---verbose") > 2);
	($rheader,$rcrlf,$htmlcontenido) = ($respuestacompleta =~ /^(.+?)(\r?\n\r?\n)(.+)$/s);
	$rcrlf = &main::mods("Cheat---crlf-res") if(&main::mods("Cheat---crlf-res") ne "");
	if($rheader =~ /\nTransfer-Encoding:\s+chunked\r?\n/) {
		$rheader =~ s/(\r?\n)Transfer-Encoding:\s+chunked\r?\n/$1/;
		$htmlcontenido = tools::dechunk($htmlcontenido);
	}
	if($rheader =~ /\nContent-Encoding:\s+(gzip|deflate)\r?\n/i) {
		my $compresion = $1;
		print "[-] ".dic::comunes($idioma,28).": ".$compresion."\n" if(&main::mods("Cheat---verbose") > 1);
		if($compresion eq "gzip" && &main::mods("IO::Uncompress::Gunzip") == 1) {
			$htmlcontenido = tools::descomprimirgzip($htmlcontenido);
		} elsif($compresion eq "gzip") {
			print "\n[x] ".dic::mensajes($idioma,25)."\n\n";
		}
		if($compresion eq "deflate" && &main::mods("IO::Uncompress::Gunzip") == 1) {
			$htmlcontenido = tools::descomprimirdeflate($htmlcontenido);
		} elsif($compresion eq "deflate") {
			print "\n[x]".dic::mensajes($idioma,26)."\n\n";
		}
		$rheader =~ s/Content-Encoding:\s+(gzip|deflate)\r?\n//;
	}
	if($eliminarssl == 1) {
		$htmlcontenido =~ s/("|'|\()https:\/\/(.+?)("|'|\))/$1http:\/\/$2\?&08dae2760be9fe48274a74c31fba5b0f$3/ig;
		$rheader =~ s/Location:\shttps:\/\/(.+?)(\r\n|\n)/Location: http:\/\/$1\?&08dae2760be9fe48274a74c31fba5b0f$2/ig;
	}
	$rheader = reglas($rheader,"rheader",$paqenv);
	$htmlcontenido = reglas($htmlcontenido,"rcontenido",$paqenv);
	my $nsize = length($htmlcontenido);
	$rheader =~ s/(Content-Length:[\s\t]+)\d+/$1$nsize/gi;
	my $isbin = 0;
	my ($ctype) = ($rheader =~ /Content-Type:\s+([^\r\n]+)/i);
	if($ctype !~ /^text\//i) {
		$isbin = 1;
	}
	print $rheader."\n\n" if(&main::mods("Cheat---verbose") == 1);
	$respuestacompleta = $rheader.$rcrlf.$htmlcontenido;
	if($controlado == 0) {
		print $navegador $respuestacompleta if($navegador);
	} else {
		if($isbin == 1) {
			control($semilla,"Binary data",1);
			print $navegador $respuestacompleta if($navegador);
			$ventanaexistente = 0;
#			$lockleer = 0;
		} else {
#			$lockleer = 1;
			control($semilla,$respuestacompleta,1);
			while($sendserv == 0) {sleep(1);}
			$sendserv = 0;
			my $buffer = $text2->get_buffer;
			my $paq = $buffer->get_text($buffer->get_start_iter,$buffer->get_end_iter,1);
			$buffer->set_text("");
			print $navegador $paq;
		}
	}
	close($navegador) if($navegador);
}


sub reglas {
	my $linea = $_[0];
	my $a = $_[1];
	my $paqenvio = $_[2];
	my $envio = 0;
	if($a =~ /^(url|reqline|header|postdata)$/) {
		$envio = 1;
	}
	$linea = $modulos->callbacks($a,$linea,$paqenvio);
	open REG,"reglas.txt";
	while(<REG>) {
		my ($d,$u,$o) = ($_ =~ /^([^\s]+)\s+(.+?)\s*=>\s*(.*)$/);
		$d =~ s/:+$//;
		if($u ne "" &&
			 (
				(&main::mods("Gtk2") == 1 && $ssl->get_active && $d =~ /^$a:nossl$/i) || $d =~ /^$a$/i ||
				$d =~ /^todo$/i || ($d eq "envio" && $envio == 1)
			 )
		) {
			($u,$o) = decode($u,$o,$linea);
			$linea =~ s/$u/$o/ig;
		}
	}
	close(REG);
	if($a eq "url") {
		$linea =~ s/\s/%20/g;
	}
	return $linea;
} 


sub proxy {
	$ventanaexistente = 1 if(&main::mods("Gtk2") == 1 && $adv->get_active);
	my ($navegador,$semilla) = @_;
	binmode $navegador;
	my $host = "";
	my $puerto = 80;
	my $servidor;
	my $url = "";
	my $version = "";
	my $metodo = "";
	my $ssl = 0;
	my $socket;
	my $lostthreads;
	my $contador = 0;
	my $ch = " ";
	my $crlf = (&main::mods("Cheat---crlf-req") ne "") ? &main::mods("Cheat---crlf-req") : "\r\n";
	my $controlado = 0;
	my %request = &tools::leerrequest($navegador);
	if($request{"postdata"} ne "") {
		$request{"postdata"} = reglas($request{"postdata"},"postdata");
		if($nivelofuscacion >= 1) {
			$request{"postdata"} = &tools::encodeparam($request{"postdata"});
			my $nuevolargopostdata = length($request{"postdata"});
			$request{"request"} =~ s/(\r?\nContent-Length:[\s\t]+)(\d+)/$1$nuevolargopostdata/g;
		}
	}
	$request{"request"} =~ s/(\r?\n)Accept-Encoding:[\s\t]+[^\r\n]+/$1Accept-Encoding: None/g;
	$request{"request"} =~ s/(\r?\n)(Proxy-)?Connection:[\s\t]+Keep-Alive/$1Connection: close/i;
	$request{"request"} =~ s/\r?\nKeep-Alive:([^\r\n]+)//i;
	$request{"request"} =~ s/\r?\nKeep-Alive:([^\r\n]+)//i;
	$request{"request"} =~ s/\r//g;
	my @lineas = split(/\n/,$request{"request"});
	my $conteolineas = -1;
	foreach my $linea (@lineas) {
		$conteolineas++;
		next if($conteolineas == 0);
		$lineas[$conteolineas] = reglas($linea,"header");
	}
	if($nivelofuscacion >= 2 ) {
		$request{"request"} =~ s/(\r?\n)([^\t\s:]+:)[\s\t]+([^\r?\n]+)/$1$2$ch$3/g;
	}
	$lineas[0] = reglas($lineas[0],"reqline");
	if($lineas[0] =~ /^(\w+)[\s\t]+([^\t\s]+)[\s\t]+HTTP\/1\.(1|0)/i) {
		($metodo,$url,$version) = ($1,$2,$3);
		if($url !~ /^https?:\/\//i) {
			if($request{"request"} =~ /(\r?\n)Host:[\s\t]+([^\r\n]+)/) {
					$url = "http://".(($2 =~ /\//) ? "/" : "").$2.$url;
					print "Nueva url: ".$url."\n";
			}
		}	
		if(&main::mods("Gtk2") == 1) {
			my $filt = $filtro->get_text;
			if($lineas[0] =~ /$filt/ && $adv->get_active) {
				$controlado = 1;
			}
		} else {$controlado = 0;}
		# detectamos ssl
		if($url =~ /\?&08dae2760be9fe48274a74c31fba5b0f$/) {
			$url =~ s/\?&08dae2760be9fe48274a74c31fba5b0f$//;
			$ssl = 1;
		}
		# termina detectamos ssl
		# extraemos host
		if($url =~ /^(https?:\/\/)/) {
			# bloque linea inicial
			$url = reglas($url,"url");
			my ($proto,$host,$hostheader,$path,$puerto) = &tools::parseurl($url);
			# comenzamos a ofuscar parametros
			if($nivelofuscacion >= 2) {
				if($path =~ /^([^\?]*)\?(.*)$/) {
					($path, $parametros) = ($1,$2);
					$parametros = tools::encodeparam($parametros);
					$path = tools::encodeuri($path)."?".$parametros;
				} else {
					$path = tools::encodeuri($path);
				}
				$lineas[0] = join "",$metodo,$ch,$path,$ch,"HTTP/1.",$version;
			} else {
				$lineas[0] = join "",$metodo," ",$path," HTTP/1.",$version;
			}
			# termina bloque linea inicial
			# inicia bloque host
			die("[x] Infinite Loop!\n") if(($host eq "localhost" || $host eq "127.0.0.1") && $puerto eq $puertoescucha);
			if($lostthreads ne dic::comunes($idioma,30)."!") {
				my $tunnel = 0;
				if($ssl == 0) {
					my $payloadconexion = "";
					my $hostsocket = $host;
					my $puertosocket = $puerto;
					if(&main::mods("Cheat---proxy") =~ /^([^:]+):(\d+)$/){
						$hostsocket = $1;
						$puertosocket  = $2;
						print dic::mensajes($idioma,6).": ".$hostsocket.":".$puertosocket."\n"  if(&main::mods("Cheat---verbose") > 0);
						$tunnel = 1;
					}
					$servidor = IO::Socket::INET->new(PeerAddr => $hostsocket, PeerPort => $puertosocket, Proto => 'tcp') or sub {close($navegador); die("[x] ".dic::mensajes($idioma,28).": ".$@."\n");};
					if(!$servidor) {
						print $navegador "HTTP/1.1 500 Internal Server Error\r\nServer: fhttp-By-Xianur0\r\nContent-Type: text/html\r\nContent-Length: 125\r\n\r\n<html>\r\n<head>\r\n<title>Server Error</title>\r\n</head>\r\n<body>\r\nLo lamento, no puedo conectar al objetivo :(\r\n</body>\r\n</html>\r\n\r\n";
						close($navegador);
						die();
					} else {
						if(&main::mods("Cheat---tunnel-http") == 1) {
							if(&main::mods("Cheat---proxy-list") ne "") {
								open(PROXYLIST,	&main::mods("Cheat---proxy-list")) || die(dic::mensajes($idioma,29)."! (".(&main::mods("Cheat---proxy-list")).")\n");
								while(my $nodoproxy = <PROXYLIST>) {
									my ($nodoaddr,$nodopuerto) = ($nodoproxy =~ /^([^:]+):(\d+)/);
									print "-> ".$nodoaddr.":".$nodopuerto."\n"  if(&main::mods("Cheat---verbose") > 0);
									if(0 == tools::maketunnel($servidor,$nodoaddr,$nodopuerto,1)) {
										print $navegador "HTTP/1.1 500 Internal Server Error\r\nServer: fhttp-By-Xianur0\r\nContent-Type: text/html\r\n\r\n<html>\r\n<head>\r\n<title>Server Error</title>\r\n</head>\r\n<body>\r\nBloqueado por el proxy :(\n</body>\r\n</html>\r\n\r\n";
										close($navegador);
										exit();
									} else {
										print "ok!\n"  if(&main::mods("Cheat---verbose") > 0);
									}
								}
							
							} elsif($tunnel == 1) {
								unless(&tools::maketunnel($servidor,$host,$puerto,1)) {
									print $navegador "HTTP/1.1 500 Internal Server Error\r\nServer: fhttp-By-Xianur0\r\nContent-Type: text/html\r\n\r\n<html>\r\n<head>\r\n<title>Server Error</title>\r\n</head>\r\n<body>\r\nBloqueado por el proxy :(\n</body>\r\n</html>\r\n\r\n";
									close($navegador);
									exit();
								}
							}
						}
					}
				} else {
					if(&main::mods("IO::Socket::SSL") == 1) {
						my $destssl = $host.":".$puerto;
						$servidor = IO::Socket::SSL->new($destssl);
					} else {
						die("\n[x] ".dic::mensajes($idioma,21)."\n\n");
					}
					if(!$servidor) {
						print $navegador "HTTP/1.1 500 Internal Server Error\r\nServer: fhttp-By-Xianur0\r\nContent-Type: text/html\r\nContent-Length: 125\r\n\r\n<html>\r\n<head>\r\n<title>Server Error</title>\r\n</head>\r\n<body>\r\nLo lamento, no puedo conectar al objetivo :(\r\n</body>\r\n</html>\r\n\r\n";
						die();
					}
					$ssl = 0;
				}
#				binmode $servidor;
				$desactivado = 0;
				$conteo++;
				$lostthreads = dic::comunes($idioma,30)."!";
			}
			$socket = $servidor;
			} else {
				die(dic::comunes($idioma,31)."!\n");
			}
			if($nivelofuscacion >= 3){
				$lineas[0] = join "","POST",$ch,"/",$ch,"HTTP/1.1\r\nContent-Type:",$ch,"application/x-www-form-urlencoded\r\nContent-Length:",$ch,"0\r\nHost:",$ch,$host,"\r\n\r\nPOST",$ch,"/",$ch,"HTTP/1.1\r\nHost:",$ch,$host,"\r\nContent-Type:",$ch,"application/x-www-form-urlencoded\r\nContent-Length:",$ch,"21\r\n\r\n123456789012345678901",$lineas[0];
			}
			# termina bloque host
	} else {
		die(dic::comunes($idioma,32)."!: ".$lineas[0]."\n");
	}
	$request{"request"} = join($crlf,@lineas);
	$request{"request"} .= $crlf.$crlf;
	my $pila = $request{"request"}.$request{"postdata"};
	my $loenviado = "";
	if($controlado == 0) { # si no estamos en adv o no pasa el filtro :P
		print $servidor $pila if($servidor); # mandamos todo al server...
		print $pila."\n"  if(&main::mods("Cheat---verbose") > 0);
		$loenviado = $pila;
	} else {
		control($semilla,$pila,0);
		while($sendnav == 0) {sleep(1);}
		$sendnav = 0;
		my $buffer = $text1->get_buffer;
		my $paq = $buffer->get_text($buffer->get_start_iter,$buffer->get_end_iter,1);
		$buffer->set_text("");
		$text1->set_buffer($buffer);
		print $servidor $paq;
		$loenviado = $paq;
	}
	leer($servidor,$navegador,$controlado,$loenviado);
}

sub grafico {
	# ventana avanzada
	my $ventana2 = Gtk2::Window->new('toplevel');
	$ventana2->set_title("Proxy");
	$ventana2->set_border_width(4);
	$ventana2->resize(600, 300);
	my $hboxx = Gtk2::HBox->new(0, 0);
	my $hboxx2 = Gtk2::HButtonBox->new();
	$hboxx2->set_layout( 'spread' );
	my $vboxx = Gtk2::VBox->new(0, 1);
	my $vp = Gtk2::Viewport->new (undef,undef);
	my $vp2 = Gtk2::Viewport->new (undef,undef);
	my $scrolledd = Gtk2::ScrolledWindow->new();
	$scrolledd->set_policy( 'automatic', 'automatic' ); 
	my $scrolledd2 = Gtk2::ScrolledWindow->new();
	$scrolledd2->set_policy( 'automatic', 'automatic' ); 
	$text1->set_size_request( 0, 500 );
	$text2->set_size_request( 0, 500 );
	$scrolledd->add($vp);
	$scrolledd2->add($vp2);
	$vp->add($text1);
	$vp2->add($text2);
	my $frame = Gtk2::Frame->new('Nav->Proxy');
	my $frame2 = Gtk2::Frame->new('Proxy->Serv');
	$frame->set_border_width( 5 );
	$frame2->set_border_width( 5 );
	$frame2->set_size_request( 0, 250 );
	$frame2->add($scrolledd2);
	$frame->set_size_request( 0, 250 );
	$frame->add($scrolledd);
	$hboxx->pack_start($frame,FALSE,FALSE,0);
	$hboxx->pack_end($frame2,FALSE,FALSE,0);
	$hboxx2->add($botone);
	$hboxx2->add($botone2);
	$vboxx->pack_start($hboxx,TRUE,TRUE,3);
	$vboxx->pack_end($hboxx2,FALSE,FALSE,1);
	$vboxx->show;
	$ventana2->add($vboxx);
	$ventana2->show_all;
	$botone->signal_connect('clicked' => sub {
		return if($desactivado == 1);
		$desactivado = 1;
		my $buffer = $text1->get_buffer;
		my $texto = $buffer->get_text($buffer->get_start_iter,$buffer->get_end_iter,1);
		$desactivado2 = 0;
		$sendnav = 1;
	});
	$botone2->signal_connect('clicked' => sub {
		return if($desactivado2 == 1);
		$desactivado2 = 1;
		$ventanaexistente = 0;
		close($servidor) if($servidor);
		$sendserv = 1;
	});
	my $ventana = Gtk2::Window->new('toplevel');
	$ventana->set_title("Proxy");
	$ventana->set_default_icon_from_file("icono.jpg");
	$ventana->set_border_width(5);
	$ventana->set_default_size(20, 20);
	$ventana->set_resizable(FALSE);
	$hbox = Gtk2::VBox->new(0, 0);
	$hbox->set_border_width(5);
	$caja = Gtk2::HBox->new(0,0);
	$etiqueta = Gtk2::Label->new(dic::comunes($idioma,2).': ');
	$puerto = Gtk2::Entry->new_with_max_length(5);
	$puerto->set_text(802);
	&main::share($puerto);
	$etiqueta = Gtk2::Label->new(dic::comunes($idioma,24).': ');
	$filtro = Gtk2::Entry->new();
	&main::share($filtro);
	$caja->pack_start($etiqueta, FALSE,FALSE,2);
	$caja->pack_start($puerto, FALSE,FALSE,2);
	$caja3 = Gtk2::HBox->new(0,0);
	$ssl = Gtk2::CheckButton->new_with_label('no-ssl');
	$adv = Gtk2::CheckButton->new_with_label(dic::comunes($idioma,33));
	&main::share($adv);
	$caja3->pack_start($ssl, FALSE,FALSE,2);
	$caja3->pack_start($adv, FALSE,FALSE,2);
	&main::share($ssl);
	$etiqueta3 = Gtk2::Label->new(dic::comunes($idioma,25).':');
	$caja2 = Gtk2::HBox->new(0,0);
	$radiobutton1 = Gtk2::RadioButton->new_with_label('grupo', '0');
	@grupo = $radiobutton1->get_group;
	$radiobutton2 = Gtk2::RadioButton->new_with_label(@grupo, '1');
	$radiobutton3 = Gtk2::RadioButton->new_with_label(@grupo, '2');
	$radiobutton4 = Gtk2::RadioButton->new_with_label(@grupo, 'Experimental');
	$caja2->pack_start($radiobutton1, FALSE,FALSE,2);
	$caja2->pack_start($radiobutton2, FALSE,FALSE,2);
	$caja2->pack_start($radiobutton3, FALSE,FALSE,2);
	$caja2->pack_start($radiobutton4, FALSE,FALSE,2);
	&main::share($radiobutton1);
	&main::share($radiobutton2);
	&main::share($radiobutton3);
	$boton = Gtk2::Button->new(dic::fingerlabels($idioma,1));
	$boton->signal_connect('clicked' => sub {
															if($boton->get_label ne dic::fingerlabels($idioma,3)) {
															$hilovivo = 1;
															$threadproxy = threads->create('comenzar');
															sleep(2);
															$boton->set_label(dic::fingerlabels($idioma,3)) if($threadproxy->is_running());
														}
														elsif($threadproxy->is_running()) {
															$hilovivo = 0;
															sleep(2);
															$threadproxy->kill('KILL')
																		if($threadproxy->is_running());
															sleep(2);
															die(dic::mensajes($idioma,25)."!")
																		if($threadproxy->is_running());
															$boton->set_label(dic::fingerlabels($idioma,1));
														}
													}
							);
	$imagen = Gtk2::Image->new_from_file("logo.png");
	$hbox->pack_start($imagen, FALSE, FALSE, 2);
	$hbox->pack_start($caja, FALSE, FALSE, 2);
	$hbox->pack_start($etiqueta3, FALSE, FALSE, 2);
	$hbox->pack_start($caja2, FALSE, FALSE, 2);
	$hbox->pack_start($caja3, FALSE, FALSE, 2);
	$hbox->pack_start($boton, FALSE, FALSE, 2);
	$hbox->pack_start($mostrar,FALSE,FALSE,2);
	$hbox->show;
	$ventana->add($hbox);
	$ventana->show_all;
	Gtk2->main;

}


sub new {
	if(&main::mods("Gtk2") == 1) {
		grafico();
	}
	elsif($#ARGV >= 3) {
		$hilovivo = 1;
		comenzar();
	} else {
		die(dic::comunes($idioma,0).": fhttp.pl 3 [".dic::comunes($idioma,35).":] [".dic::comunes($idioma,24)."] [no-ssl 0|1]\n");
	}
}

1;
