/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import com.jpexs.proxy.ProxyConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class Connection {
    Socket socket = null;
    InputStream in = null;
    OutputStream out = null;
    static SSLSocketFactory sf;

    public void promoteToClientSSL() {
        SSLSocketFactory f = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            this.socket = (SSLSocket)f.createSocket(this.socket, null, this.socket.getPort(), false);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void promoteToServerSSL() {
        try {
            this.socket = sf.createSocket(this.socket, null, this.socket.getPort(), false);
            ((SSLSocket)this.socket).setUseClientMode(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    Connection(String host, int port) throws IOException {
        this(new Socket(InetAddress.getByName(host), port));
    }

    Connection() {
    }

    InputStream getInputStream() {
        return this.in;
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setInputStream(InputStream in) {
        this.in = in;
    }

    void setOutputStream(OutputStream out) {
        this.out = out;
    }

    void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public String toString() {
        return this.getInetAddress().getHostAddress() + ":" + this.getPort();
    }

    public void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    static {
        String ksName = ProxyConfig.httpsKeyStoreFile;
        if (ksName != null) {
            char[] ksPass = ProxyConfig.httpsKeyStorePass.toCharArray();
            char[] ctPass = ProxyConfig.httpsKeyPass.toCharArray();
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(ksName), ksPass);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, ctPass);
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(kmf.getKeyManagers(), null, null);
                sf = sc.getSocketFactory();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

