/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import com.jpexs.proxy.CatchedListener;
import com.jpexs.proxy.Client;
import com.jpexs.proxy.Copy;
import com.jpexs.proxy.Http;
import com.jpexs.proxy.HttpConnection;
import com.jpexs.proxy.HttpError;
import com.jpexs.proxy.HttpRelay;
import com.jpexs.proxy.Https;
import com.jpexs.proxy.HttpsThrough;
import com.jpexs.proxy.ProxyConfig;
import com.jpexs.proxy.ReplacedListener;
import com.jpexs.proxy.Replacement;
import com.jpexs.proxy.Reply;
import com.jpexs.proxy.Request;
import com.jpexs.proxy.RetryRequestException;
import com.jpexs.proxy.ReusableThread;
import com.jpexs.proxy.Server;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLHandshakeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Handler
implements Runnable {
    static final boolean DEBUG = false;
    Client client = null;
    Socket socket = null;
    Request request = null;
    Reply reply = null;
    HttpRelay http = null;
    int currentLength = -1;
    int contentLength = -1;
    long idle = 0L;
    double bytesPerSecond = 0.0;
    List<Replacement> replacements;
    CatchedListener catchedListener;
    List<String> catchedContentTypes;
    ReplacedListener replacedListener;
    static int curId = 0;
    int id = ++curId;

    Handler(Socket socket, List<Replacement> replacements, List<String> catchedContentTypes, CatchedListener catchedListener, ReplacedListener replacedListener) {
        this.socket = socket;
        this.replacements = replacements;
        this.catchedListener = catchedListener;
        this.catchedContentTypes = catchedContentTypes;
        this.replacedListener = replacedListener;
    }

    synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.http != null) {
            this.http.close();
            this.http = null;
        }
    }

    void flush() {
        if (this.client != null) {
            try {
                this.client.getOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean keepAlive = false;
        Throwable reason = null;
        Thread.currentThread().setName("Handler(" + this.socket.getInetAddress().getHostAddress() + ")");
        try {
            this.client = new Client(this.socket);
            this.client.setTimeout(ProxyConfig.readTimeout);
        }
        catch (IOException e) {
            return;
        }
        boolean secure = false;
        int securePort = 443;
        String secureServer = "";
        do {
            block15: {
                this.request = null;
                this.reply = null;
                this.idle = System.currentTimeMillis();
                try {
                    this.request = this.client.read();
                    if (!secure) break block15;
                    this.request.addSecureHostToURL(secureServer);
                }
                catch (SSLHandshakeException she) {
                    she.printStackTrace();
                    break;
                }
                catch (IOException e) {
                    break;
                }
            }
            if (this.request.getCommand().equals("CONNECT")) {
                secureServer = this.request.getHost();
                securePort = this.request.getPort();
                if (ProxyConfig.httpsMode == 1 || ProxyConfig.httpsMode == 2 && ProxyConfig.enabledHttpsServers.contains(secureServer)) {
                    secure = true;
                    this.reply = new Reply();
                    this.reply.statusLine = "HTTP/1.0 200 Connection established";
                    this.reply.setHeaderField("Proxy-agent", ProxyConfig.appName);
                    try {
                        this.client.write(this.reply);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    this.client.promoteToServerSSL();
                    keepAlive = true;
                    continue;
                }
            }
            this.idle = 0L;
            try {
                keepAlive = this.processRequest(secure, secureServer, securePort);
            }
            catch (IOException ioe) {
                reason = ioe;
                keepAlive = false;
            }
            if (this.request == null || this.reply == null || this.reply == null || this.currentLength <= 0) continue;
            this.reply.setHeaderField("Content-length", this.currentLength);
        } while (keepAlive);
        if (reason != null && reason.getMessage().indexOf("Broken pipe") == -1 && this.client != null && this.request != null) {
            this.error(this.client.getOutputStream(), (Exception)reason, this.request);
        }
        this.close();
    }

    boolean processRequest(boolean secure, String secureHost, int securePort) throws IOException {
        boolean keepAlive = false;
        while (this.reply == null) {
            String url;
            boolean uncompress = false;
            if (this.request.getCommand().equals("CONNECT")) {
                secure = true;
            } else if (!(this.request.getURL().startsWith("/") || this.request.getURL().startsWith("https://") && secure || this.request.getURL().startsWith("http://"))) {
                return false;
            }
            if (ProxyConfig.proxyKeepAlive) {
                keepAlive = this.request.containsHeaderField("Proxy-Connection") && this.request.getHeaderField("Proxy-Connection").equals("Keep-Alive");
            }
            this.http = secure ? this.createHttpsRelay(secureHost, securePort) : this.createHttpRelay();
            try {
                this.http.sendRequest(this.request);
                if (this.http instanceof Http) {
                    ((Http)this.http).setTimeout(ProxyConfig.readTimeout);
                }
                this.reply = this.http.recvReply(this.request);
            }
            catch (RetryRequestException e) {
                this.http.close();
                this.http = null;
                continue;
            }
            if (this.reply.headerCount() == 0 && ((url = this.request.getURL()).endsWith("/") || url.endsWith(".html") || url.endsWith(".htm"))) {
                this.reply.setHeaderField("Content-type", "text/html");
            }
            if (this.request.containsHeaderField("Connection") && this.request.getHeaderField("Connection").toLowerCase().equals("keep-alive") && this.reply.containsHeaderField("Connection") && this.reply.getHeaderField("Connection").equals("Keep-Alive")) {
                keepAlive = true;
            }
            this.reply.removeHeaderField("Proxy-Connection");
            if (keepAlive && this.reply.containsHeaderField("Content-length")) {
                this.reply.setHeaderField("Proxy-Connection", "Keep-Alive");
            } else {
                keepAlive = false;
            }
            this.currentLength = -1;
            this.contentLength = -1;
            try {
                this.contentLength = Integer.parseInt(this.reply.getHeaderField("Content-length"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (this.http instanceof HttpsThrough) {
                HttpsThrough https = (HttpsThrough)this.http;
                int timeout = ProxyConfig.readTimeout;
                this.client.write(this.reply);
                try {
                    this.client.setTimeout(timeout);
                    https.setTimeout(timeout);
                    Copy cp = new Copy(this.client.getInputStream(), https.getOutputStream());
                    ReusableThread thread = Server.getThread();
                    thread.setRunnable(cp);
                    this.flushCopy(https.getInputStream(), this.client.getOutputStream(), -1, true);
                    this.client.close();
                }
                catch (InterruptedIOException iioe) {}
            } else if (this.reply.hasContent()) {
                try {
                    this.processContent(uncompress);
                }
                catch (IOException e) {
                    if (this.http instanceof Http) {
                        ((Http)this.http).reallyClose();
                    } else {
                        this.http.close();
                    }
                    this.http = null;
                    this.client.close();
                    this.client = null;
                    throw e;
                }
                if (this.contentLength == 0) {
                    this.client.close();
                }
            } else {
                this.client.write(this.reply);
            }
            this.http.close();
        }
        return keepAlive;
    }

    HttpRelay createHttpsRelay(String secureHost, int securePort) throws IOException {
        HttpConnection http;
        if (ProxyConfig.httpsMode == 1 || ProxyConfig.httpsMode == 2 && ProxyConfig.enabledHttpsServers.contains(secureHost)) {
            if (ProxyConfig.useHTTPSProxy) {
                http = Https.open(ProxyConfig.httpsProxyHost, ProxyConfig.httpsProxyPort, true);
                Request connectReq = new Request(null);
                connectReq.setStatusLine("CONNECT " + secureHost + ":" + securePort + " HTTP/1.1");
                connectReq.setCommand("CONNECT");
                connectReq.setURL(secureHost + ":" + securePort);
                connectReq.setProtocol("HTTP/1.1");
                try {
                    http.sendRequest(connectReq);
                    Reply rep = http.recvReply(connectReq);
                }
                catch (RetryRequestException ex) {
                    // empty catch block
                }
                ((Https)http).promoteToClientSSL();
            } else {
                http = Https.open(secureHost, securePort, false);
                ((Https)http).promoteToClientSSL();
            }
        } else {
            http = ProxyConfig.useHTTPSProxy ? new HttpsThrough(ProxyConfig.httpsProxyHost, ProxyConfig.httpsProxyPort, true) : new HttpsThrough(secureHost, securePort);
        }
        return http;
    }

    HttpRelay createHttpRelay() throws IOException {
        Http http = ProxyConfig.useHTTPProxy ? Http.open(ProxyConfig.httpProxyHost, ProxyConfig.httpProxyPort, true) : Http.open(this.request.getHost(), this.request.getPort());
        return http;
    }

    InputStream readChunkedTransfer(InputStream in) throws IOException {
        ByteArrayOutputStream chunks = new ByteArrayOutputStream(8192);
        int size = 0;
        this.contentLength = 0;
        while ((size = this.reply.getChunkSize(in)) > 0) {
            this.contentLength += size;
            this.copy(in, chunks, size, true);
            this.reply.readLine(in);
        }
        this.reply.getChunkedFooter(in);
        this.reply.removeHeaderField("Transfer-Encoding");
        this.reply.setHeaderField("Content-length", this.contentLength);
        return new ByteArrayInputStream(chunks.toByteArray());
    }

    private static DateFormat httpDateFormat() {
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return httpDateFormat;
    }

    void disableReplyCaching() {
        this.reply.removeHeaderField("Cache-Control");
        this.reply.removeHeaderField("Last-Modified");
        this.reply.removeHeaderField("Expires");
        this.reply.removeHeaderField("Date");
        this.reply.removeHeaderField("ETag");
        this.reply.removeHeaderField("Pragma");
        this.reply.setHeaderField("Pragma", "no-cache");
        this.reply.setHeaderField("Cache-Control", "no-cache, must-revalidate");
        Calendar now = Calendar.getInstance();
        this.reply.setHeaderField("Expires", Handler.httpDateFormat().format(now.getTime()));
        this.reply.setHeaderField("Last-Modified", "Sat, 26 Jul 1997 05:00:00 GMT");
    }

    void processContent(boolean uncompress) throws IOException {
        InputStream in;
        boolean chunked = false;
        if (this.reply.containsHeaderField("Transfer-Encoding") && this.reply.getTransferEncoding().equals("chunked")) {
            in = this.readChunkedTransfer(this.reply.getContent());
            chunked = true;
        } else {
            in = this.reply.getContent();
        }
        if (in == null) {
            return;
        }
        if (uncompress) {
            in = new GZIPInputStream(in);
        }
        String url = this.request.getURL();
        boolean replaced = false;
        for (Replacement r : this.replacements) {
            if (!r.matches(url)) continue;
            r.lastAccess = Calendar.getInstance();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                FileInputStream fis = new FileInputStream(r.targetFile);
                byte[] buf = new byte[2048];
                int pos = 0;
                while ((pos = fis.read(buf)) > 0) {
                    buffer.write(buf, 0, pos);
                }
                fis.close();
                buffer.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            byte[] bytes = buffer.toByteArray();
            this.contentLength = bytes.length;
            this.reply.setHeaderField("Content-length", this.contentLength);
            this.disableReplyCaching();
            this.client.write(this.reply);
            this.copy(new ByteArrayInputStream(bytes), this.client.getOutputStream(), this.contentLength, false);
            replaced = true;
            if (this.replacedListener == null) break;
            this.replacedListener.replaced(r, this.request.getURL(), this.reply.getContentType());
            break;
        }
        if (!replaced) {
            String contentType = this.reply.getHeaderField("Content-type");
            if (this.reply.getStatusCode() == 200 && contentType != null) {
                for (String ct : this.catchedContentTypes) {
                    String convContentType = contentType;
                    if (convContentType.contains(";")) {
                        convContentType = convContentType.substring(0, convContentType.indexOf(";"));
                    }
                    if (!ct.toLowerCase().equals(convContentType.toLowerCase())) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.copy(in, baos, this.contentLength, true);
                    if (this.catchedListener != null) {
                        this.catchedListener.catched(ct, this.request.getURL(), new ByteArrayInputStream(baos.toByteArray()));
                    }
                    in = new ByteArrayInputStream(baos.toByteArray());
                    this.disableReplyCaching();
                    break;
                }
            }
            this.client.write(this.reply);
            this.copy(in, this.client.getOutputStream(), this.contentLength, true);
        }
    }

    int getTotalBytes() {
        return this.contentLength > 0 ? this.contentLength : 0;
    }

    int getCurrentBytes() {
        return this.currentLength > 0 ? this.currentLength : 0;
    }

    void error(OutputStream out, Exception e, Request r) {
        StringBuffer buf = new StringBuffer();
        buf.append("While trying to retrieve the URL: <a href=\"" + r.getURL() + "\">" + r.getURL() + "</a>\r\n");
        buf.append("<p>\r\nThe following error was encountered:\r\n<p>\r\n");
        buf.append("<ul><li>" + e.toString() + "</ul>\r\n");
        String s = new HttpError(400, buf.toString()).toString();
        try {
            out.write(s.getBytes(), 0, s.length());
            out.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    void copy(InputStream in, OutputStream out, int length, boolean monitored) throws IOException {
        if (length == 0) {
            return;
        }
        byte[] buffer = new byte[8192];
        long start = System.currentTimeMillis();
        long now = 0L;
        long then = start;
        this.bytesPerSecond = 0.0;
        if (monitored) {
            this.currentLength = 0;
        }
        while (true) {
            int n = length > 0 ? Math.min(length, buffer.length) : buffer.length;
            if ((n = in.read(buffer, 0, n)) < 0) break;
            out.write(buffer, 0, n);
            if (monitored) {
                this.currentLength += n;
            }
            now = System.currentTimeMillis();
            this.bytesPerSecond = (double)this.currentLength / ((double)(now - start) / 1000.0);
            if (now - then > 1000L) {
                out.flush();
            }
            if (length != -1 && (length -= n) == 0) break;
            then = now;
        }
        out.flush();
    }

    void flushCopy(InputStream in, OutputStream out, int length, boolean monitored) throws IOException {
        int n;
        if (length == 0) {
            return;
        }
        byte[] buffer = new byte[8192];
        long start = System.currentTimeMillis();
        this.bytesPerSecond = 0.0;
        if (monitored) {
            this.currentLength = 0;
        }
        do {
            n = length > 0 ? Math.min(length, buffer.length) : buffer.length;
            if ((n = in.read(buffer, 0, n)) < 0) break;
            out.write(buffer, 0, n);
            out.flush();
            if (monitored) {
                this.currentLength += n;
            }
            this.bytesPerSecond = (double)this.currentLength / ((double)(System.currentTimeMillis() - start) / 1000.0);
        } while (length == -1 || (length -= n) != 0);
        out.flush();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("CLIENT ");
        str.append(this.socket.getInetAddress().getHostAddress());
        str.append(":");
        str.append(this.socket.getPort());
        str.append(" - ");
        if (this.request == null) {
            str.append("idle " + (double)(System.currentTimeMillis() - this.idle) / 1000.0 + " sec");
        } else {
            if (this.reply != null && this.currentLength > 0) {
                str.append("(");
                str.append(this.currentLength);
                if (this.contentLength > 0) {
                    str.append("/");
                    str.append(this.contentLength);
                }
                str.append(" ");
                str.append((int)this.bytesPerSecond / 1024 + " kB/s");
                str.append(") ");
            }
            str.append(this.request.getURL());
        }
        return str.toString();
    }
}

