/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc;

import com.jpexs.asdec.EventListener;
import com.jpexs.asdec.abc.ABCInputStream;
import com.jpexs.asdec.abc.ABCOutputStream;
import com.jpexs.asdec.abc.NotSameException;
import com.jpexs.asdec.abc.avm2.AVM2Code;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.UnknownInstructionCode;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.types.ABCException;
import com.jpexs.asdec.abc.types.ClassInfo;
import com.jpexs.asdec.abc.types.Decimal;
import com.jpexs.asdec.abc.types.InstanceInfo;
import com.jpexs.asdec.abc.types.MetadataInfo;
import com.jpexs.asdec.abc.types.MethodBody;
import com.jpexs.asdec.abc.types.MethodInfo;
import com.jpexs.asdec.abc.types.Multiname;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.abc.types.NamespaceSet;
import com.jpexs.asdec.abc.types.ScriptInfo;
import com.jpexs.asdec.abc.types.traits.Trait;
import com.jpexs.asdec.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.asdec.abc.types.traits.TraitSlotConst;
import com.jpexs.asdec.abc.types.traits.Traits;
import com.jpexs.asdec.abc.usages.ClassNameMultinameUsage;
import com.jpexs.asdec.abc.usages.ConstVarNameMultinameUsage;
import com.jpexs.asdec.abc.usages.ConstVarTypeMultinameUsage;
import com.jpexs.asdec.abc.usages.ExtendsMultinameUsage;
import com.jpexs.asdec.abc.usages.ImplementsMultinameUsage;
import com.jpexs.asdec.abc.usages.MethodBodyMultinameUsage;
import com.jpexs.asdec.abc.usages.MethodNameMultinameUsage;
import com.jpexs.asdec.abc.usages.MethodParamsMultinameUsage;
import com.jpexs.asdec.abc.usages.MethodReturnTypeMultinameUsage;
import com.jpexs.asdec.abc.usages.MultinameUsage;
import com.jpexs.asdec.abc.usages.TypeNameMultinameUsage;
import com.jpexs.asdec.tags.DoABCTag;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ABC {
    public int major_version = 0;
    public int minor_version = 0;
    public ConstantPool constants;
    public MethodInfo[] method_info;
    public MetadataInfo[] metadata_info;
    public InstanceInfo[] instance_info;
    public ClassInfo[] class_info;
    public ScriptInfo[] script_info;
    public MethodBody[] bodies;
    private int[] bodyIdxFromMethodIdx;
    public long[] stringOffsets;
    public static String IDENT_STRING = "   ";
    public static final int MINORwithDECIMAL = 17;
    protected HashSet<EventListener> listeners = new HashSet();
    private static Logger logger = Logger.getLogger(ABC.class.getName());
    private HashMap<String, String> namespaceMap;
    public static final String[] reservedWords = new String[]{"as", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "each", "else", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "internal", "is", "native", "new", "null", "package", "private", "protected", "public", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "use", "var", "while", "with", "dynamic", "default", "final", "in"};
    public static final String validFirstCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
    public static final String validNextCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";
    public static final String validNsCharacters = ".:$";
    public static final String fooCharacters = "bcdfghjklmnpqrstvwz";
    public static final String fooJoinCharacters = "aeiouy";
    private HashMap<String, String> deobfuscated = new HashMap();
    private Random rnd = new Random();
    private final int DEFAULT_FOO_SIZE = 10;

    public void addEventListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    protected void informListeners(String event, Object data) {
        for (EventListener listener : this.listeners) {
            listener.handleEvent(event, data);
        }
    }

    public int deobfuscateIdentifiers() {
        int i;
        int ret = 0;
        for (i = 1; i < this.instance_info.length; ++i) {
            if (this.instance_info[i].name_index != 0 && this.deobfuscateName(this.constants.constant_multiname[this.instance_info[i].name_index].name_index, true)) {
                ++ret;
            }
            if (this.instance_info[i].super_index == 0 || !this.deobfuscateName(this.constants.constant_multiname[this.instance_info[i].super_index].name_index, true)) continue;
            ++ret;
        }
        for (i = 1; i < this.constants.constant_multiname.length; ++i) {
            if (!this.deobfuscateName(this.constants.constant_multiname[i].name_index, false)) continue;
            ++ret;
        }
        for (i = 1; i < this.constants.constant_namespace.length; ++i) {
            if (!this.deobfuscateNameSpace(this.constants.constant_namespace[i].name_index)) continue;
            ++ret;
        }
        return ret;
    }

    public ABC(InputStream is) throws IOException {
        int i;
        int i2;
        ABCInputStream ais = new ABCInputStream(is);
        this.minor_version = ais.readU16();
        this.major_version = ais.readU16();
        logger.log(Level.FINE, "ABC minor_version: {0}, major_version: {1}", new Object[]{this.minor_version, this.major_version});
        this.constants = new ConstantPool();
        int constant_int_pool_count = ais.readU30();
        this.constants.constant_int = new long[constant_int_pool_count];
        for (int i3 = 1; i3 < constant_int_pool_count; ++i3) {
            this.constants.constant_int[i3] = ais.readS32();
        }
        int constant_uint_pool_count = ais.readU30();
        this.constants.constant_uint = new long[constant_uint_pool_count];
        for (int i4 = 1; i4 < constant_uint_pool_count; ++i4) {
            this.constants.constant_uint[i4] = ais.readU32();
        }
        int constant_double_pool_count = ais.readU30();
        this.constants.constant_double = new double[constant_double_pool_count];
        for (int i5 = 1; i5 < constant_double_pool_count; ++i5) {
            this.constants.constant_double[i5] = ais.readDouble();
        }
        if (this.minor_version >= 17) {
            int constant_decimal_pool_count = ais.readU30();
            this.constants.constant_decimal = new Decimal[constant_decimal_pool_count];
            for (i2 = 1; i2 < constant_decimal_pool_count; ++i2) {
                this.constants.constant_decimal[i2] = ais.readDecimal();
            }
        } else {
            this.constants.constant_decimal = new Decimal[0];
        }
        int constant_string_pool_count = ais.readU30();
        this.constants.constant_string = new String[constant_string_pool_count];
        this.stringOffsets = new long[constant_string_pool_count];
        this.constants.constant_string[0] = "";
        for (i2 = 1; i2 < constant_string_pool_count; ++i2) {
            long pos = ais.getPosition();
            this.constants.constant_string[i2] = ais.readString();
            this.stringOffsets[i2] = pos;
        }
        int constant_namespace_pool_count = ais.readU30();
        this.constants.constant_namespace = new Namespace[constant_namespace_pool_count];
        for (int i6 = 1; i6 < constant_namespace_pool_count; ++i6) {
            this.constants.constant_namespace[i6] = ais.readNamespace();
        }
        int constant_namespace_set_pool_count = ais.readU30();
        this.constants.constant_namespace_set = new NamespaceSet[constant_namespace_set_pool_count];
        for (int i7 = 1; i7 < constant_namespace_set_pool_count; ++i7) {
            this.constants.constant_namespace_set[i7] = new NamespaceSet();
            int namespace_count = ais.readU30();
            this.constants.constant_namespace_set[i7].namespaces = new int[namespace_count];
            for (int j = 0; j < namespace_count; ++j) {
                this.constants.constant_namespace_set[i7].namespaces[j] = ais.readU30();
            }
        }
        int constant_multiname_pool_count = ais.readU30();
        this.constants.constant_multiname = new Multiname[constant_multiname_pool_count];
        for (int i8 = 1; i8 < constant_multiname_pool_count; ++i8) {
            this.constants.constant_multiname[i8] = ais.readMultiname();
        }
        int methods_count = ais.readU30();
        this.method_info = new MethodInfo[methods_count];
        this.bodyIdxFromMethodIdx = new int[methods_count];
        for (int i9 = 0; i9 < methods_count; ++i9) {
            this.method_info[i9] = ais.readMethodInfo();
            this.bodyIdxFromMethodIdx[i9] = -1;
        }
        int metadata_count = ais.readU30();
        this.metadata_info = new MetadataInfo[metadata_count];
        for (int i10 = 0; i10 < metadata_count; ++i10) {
            int name_index = ais.readU30();
            int values_count = ais.readU30();
            int[] keys = new int[values_count];
            for (int v = 0; v < values_count; ++v) {
                keys[v] = ais.readU30();
            }
            int[] values = new int[values_count];
            for (int v = 0; v < values_count; ++v) {
                values[v] = ais.readU30();
            }
            this.metadata_info[i10] = new MetadataInfo(name_index, keys, values);
        }
        int class_count = ais.readU30();
        this.instance_info = new InstanceInfo[class_count];
        for (i = 0; i < class_count; ++i) {
            this.instance_info[i] = ais.readInstanceInfo();
        }
        this.class_info = new ClassInfo[class_count];
        for (i = 0; i < class_count; ++i) {
            ClassInfo ci = new ClassInfo();
            ci.cinit_index = ais.readU30();
            ci.static_traits = ais.readTraits();
            this.class_info[i] = ci;
        }
        int script_count = ais.readU30();
        this.script_info = new ScriptInfo[script_count];
        for (int i11 = 0; i11 < script_count; ++i11) {
            ScriptInfo si = new ScriptInfo();
            si.init_index = ais.readU30();
            si.traits = ais.readTraits();
            this.script_info[i11] = si;
        }
        int bodies_count = ais.readU30();
        this.bodies = new MethodBody[bodies_count];
        int i12 = 0;
        while (i12 < bodies_count) {
            MethodBody mb = new MethodBody();
            mb.method_info = ais.readU30();
            mb.max_stack = ais.readU30();
            mb.max_regs = ais.readU30();
            mb.init_scope_depth = ais.readU30();
            mb.max_scope_depth = ais.readU30();
            int code_length = ais.readU30();
            mb.codeBytes = new byte[code_length];
            ais.read(mb.codeBytes);
            try {
                mb.code = new AVM2Code(new ByteArrayInputStream(mb.codeBytes));
            }
            catch (UnknownInstructionCode re) {
                mb.code = new AVM2Code();
                System.err.println(re.toString());
            }
            mb.code.compact();
            int ex_count = ais.readU30();
            mb.exceptions = new ABCException[ex_count];
            for (int j = 0; j < ex_count; ++j) {
                ABCException abce = new ABCException();
                abce.start = ais.readU30();
                abce.end = ais.readU30();
                abce.target = ais.readU30();
                abce.type_index = ais.readU30();
                abce.name_index = ais.readU30();
                mb.exceptions[j] = abce;
            }
            mb.traits = ais.readTraits();
            this.bodies[i12] = mb;
            this.method_info[mb.method_info].setBody(mb);
            this.bodyIdxFromMethodIdx[mb.method_info] = i12++;
        }
        this.loadNamespaceMap();
    }

    public void saveToStream(OutputStream os) throws IOException {
        int j;
        int i;
        ABCOutputStream aos = new ABCOutputStream(os);
        aos.writeU16(this.minor_version);
        aos.writeU16(this.major_version);
        aos.writeU30(this.constants.constant_int.length);
        for (i = 1; i < this.constants.constant_int.length; ++i) {
            aos.writeS32(this.constants.constant_int[i]);
        }
        aos.writeU30(this.constants.constant_uint.length);
        for (i = 1; i < this.constants.constant_uint.length; ++i) {
            aos.writeU32(this.constants.constant_uint[i]);
        }
        aos.writeU30(this.constants.constant_double.length);
        for (i = 1; i < this.constants.constant_double.length; ++i) {
            aos.writeDouble(this.constants.constant_double[i]);
        }
        if (this.minor_version >= 17) {
            aos.writeU30(this.constants.constant_decimal.length);
            for (i = 1; i < this.constants.constant_decimal.length; ++i) {
                aos.writeDecimal(this.constants.constant_decimal[i]);
            }
        }
        aos.writeU30(this.constants.constant_string.length);
        for (i = 1; i < this.constants.constant_string.length; ++i) {
            aos.writeString(this.constants.constant_string[i]);
        }
        aos.writeU30(this.constants.constant_namespace.length);
        for (i = 1; i < this.constants.constant_namespace.length; ++i) {
            aos.writeNamespace(this.constants.constant_namespace[i]);
        }
        aos.writeU30(this.constants.constant_namespace_set.length);
        for (i = 1; i < this.constants.constant_namespace_set.length; ++i) {
            aos.writeU30(this.constants.constant_namespace_set[i].namespaces.length);
            for (j = 0; j < this.constants.constant_namespace_set[i].namespaces.length; ++j) {
                aos.writeU30(this.constants.constant_namespace_set[i].namespaces[j]);
            }
        }
        aos.writeU30(this.constants.constant_multiname.length);
        for (i = 1; i < this.constants.constant_multiname.length; ++i) {
            aos.writeMultiname(this.constants.constant_multiname[i]);
        }
        aos.writeU30(this.method_info.length);
        for (i = 0; i < this.method_info.length; ++i) {
            aos.writeMethodInfo(this.method_info[i]);
        }
        aos.writeU30(this.metadata_info.length);
        for (i = 0; i < this.metadata_info.length; ++i) {
            aos.writeU30(this.metadata_info[i].name_index);
            aos.writeU30(this.metadata_info[i].values.length);
            for (j = 0; j < this.metadata_info[i].values.length; ++j) {
                aos.writeU30(this.metadata_info[i].keys[j]);
            }
            for (j = 0; j < this.metadata_info[i].values.length; ++j) {
                aos.writeU30(this.metadata_info[i].values[j]);
            }
        }
        aos.writeU30(this.class_info.length);
        for (i = 0; i < this.instance_info.length; ++i) {
            aos.writeInstanceInfo(this.instance_info[i]);
        }
        for (i = 0; i < this.class_info.length; ++i) {
            aos.writeU30(this.class_info[i].cinit_index);
            aos.writeTraits(this.class_info[i].static_traits);
        }
        aos.writeU30(this.script_info.length);
        for (i = 0; i < this.script_info.length; ++i) {
            aos.writeU30(this.script_info[i].init_index);
            aos.writeTraits(this.script_info[i].traits);
        }
        aos.writeU30(this.bodies.length);
        for (i = 0; i < this.bodies.length; ++i) {
            aos.writeU30(this.bodies[i].method_info);
            aos.writeU30(this.bodies[i].max_stack);
            aos.writeU30(this.bodies[i].max_regs);
            aos.writeU30(this.bodies[i].init_scope_depth);
            aos.writeU30(this.bodies[i].max_scope_depth);
            byte[] codeBytes = this.bodies[i].code.getBytes();
            aos.writeU30(codeBytes.length);
            try {
                aos.write(codeBytes);
            }
            catch (NotSameException ex) {
                System.out.println(this.bodies[i].code.toString(this.constants));
                System.exit(0);
                return;
            }
            aos.writeU30(this.bodies[i].exceptions.length);
            for (int j2 = 0; j2 < this.bodies[i].exceptions.length; ++j2) {
                aos.writeU30(this.bodies[i].exceptions[j2].start);
                aos.writeU30(this.bodies[i].exceptions[j2].end);
                aos.writeU30(this.bodies[i].exceptions[j2].target);
                aos.writeU30(this.bodies[i].exceptions[j2].type_index);
                aos.writeU30(this.bodies[i].exceptions[j2].name_index);
            }
            aos.writeTraits(this.bodies[i].traits);
        }
    }

    public MethodBody findBody(int methodInfo) {
        if (methodInfo < 0) {
            return null;
        }
        return this.method_info[methodInfo].getBody();
    }

    public int findBodyIndex(int methodInfo) {
        if (methodInfo == -1) {
            return -1;
        }
        return this.bodyIdxFromMethodIdx[methodInfo];
    }

    public MethodBody findBodyByClassAndName(String className, String methodName) {
        TraitMethodGetterSetter t2;
        int i;
        for (i = 0; i < this.instance_info.length; ++i) {
            if (!className.equals(this.constants.constant_multiname[this.instance_info[i].name_index].getName(this.constants, new ArrayList<String>()))) continue;
            for (Trait t : this.instance_info[i].instance_traits.traits) {
                if (!(t instanceof TraitMethodGetterSetter) || !methodName.equals((t2 = (TraitMethodGetterSetter)t).getName(this).getName(this.constants, new ArrayList<String>()))) continue;
                for (MethodBody body : this.bodies) {
                    if (body.method_info != t2.method_info) continue;
                    return body;
                }
            }
        }
        for (i = 0; i < this.class_info.length; ++i) {
            if (!className.equals(this.constants.constant_multiname[this.instance_info[i].name_index].getName(this.constants, new ArrayList<String>()))) continue;
            for (Trait t : this.class_info[i].static_traits.traits) {
                if (!(t instanceof TraitMethodGetterSetter) || !methodName.equals((t2 = (TraitMethodGetterSetter)t).getName(this).getName(this.constants, new ArrayList<String>()))) continue;
                for (MethodBody body : this.bodies) {
                    if (body.method_info != t2.method_info) continue;
                    return body;
                }
            }
        }
        return null;
    }

    public static String addTabs(String s, int tabs) {
        String[] parts = s.split("\r\n");
        if (!s.contains("\r\n")) {
            parts = s.split("\n");
        }
        String ret = "";
        for (int i = 0; i < parts.length; ++i) {
            for (int t = 0; t < tabs; ++t) {
                ret = ret + IDENT_STRING;
            }
            ret = ret + parts[i];
            if (i >= parts.length - 1) continue;
            ret = ret + "\r\n";
        }
        return ret;
    }

    public Trait findTraitByTraitId(int classIndex, int traitId) {
        if (traitId < this.class_info[classIndex].static_traits.traits.length) {
            return this.class_info[classIndex].static_traits.traits[traitId];
        }
        if (traitId < this.class_info[classIndex].static_traits.traits.length + this.instance_info[classIndex].instance_traits.traits.length) {
            return this.instance_info[classIndex].instance_traits.traits[traitId -= this.class_info[classIndex].static_traits.traits.length];
        }
        return null;
    }

    public int findMethodIdByTraitId(int classIndex, int traitId) {
        if (traitId < this.class_info[classIndex].static_traits.traits.length) {
            if (this.class_info[classIndex].static_traits.traits[traitId] instanceof TraitMethodGetterSetter) {
                return ((TraitMethodGetterSetter)this.class_info[classIndex].static_traits.traits[traitId]).method_info;
            }
            return -1;
        }
        if (traitId < this.class_info[classIndex].static_traits.traits.length + this.instance_info[classIndex].instance_traits.traits.length) {
            if (this.instance_info[classIndex].instance_traits.traits[traitId -= this.class_info[classIndex].static_traits.traits.length] instanceof TraitMethodGetterSetter) {
                return ((TraitMethodGetterSetter)this.instance_info[classIndex].instance_traits.traits[traitId]).method_info;
            }
            return -1;
        }
        if ((traitId -= this.class_info[classIndex].static_traits.traits.length + this.instance_info[classIndex].instance_traits.traits.length) == 0) {
            return this.instance_info[classIndex].iinit_index;
        }
        if (traitId == 1) {
            return this.class_info[classIndex].cinit_index;
        }
        return -1;
    }

    private void loadNamespaceMap() {
        this.namespaceMap = new HashMap();
        for (ScriptInfo si : this.script_info) {
            for (Trait t : si.traits.traits) {
                TraitSlotConst s;
                if (!(t instanceof TraitSlotConst) || !(s = (TraitSlotConst)t).isNamespace()) continue;
                String key = this.constants.constant_namespace[s.value_index].getName(this.constants);
                String val = this.constants.constant_multiname[s.name_index].getNameWithNamespace(this.constants);
                this.namespaceMap.put(key, val);
            }
        }
    }

    public String builtInNs(String ns) {
        if (ns.equals("http://www.adobe.com/2006/actionscript/flash/proxy")) {
            return "flash.utils.flash_proxy";
        }
        if (ns.equals("http://adobe.com/AS3/2006/builtin")) {
            return "-";
        }
        return null;
    }

    public String nsValueToName(String value) {
        if (this.namespaceMap.containsKey(value)) {
            return this.namespaceMap.get(value);
        }
        String ns = this.builtInNs(value);
        if (ns == null) {
            return "";
        }
        return ns;
    }

    public void export(String directory, boolean pcode, List<DoABCTag> abcList) throws IOException {
        this.export(directory, pcode, abcList, "");
    }

    public void export(String directory, boolean pcode, List<DoABCTag> abcList, String abcStr) throws IOException {
        for (int i = 0; i < this.script_info.length; ++i) {
            String path = this.script_info[i].getPath(this);
            String packageName = path.substring(0, path.lastIndexOf("."));
            if (packageName.equals("")) {
                path = path.substring(1);
            }
            String cnt = "";
            if (this.script_info.length > 1) {
                cnt = "script " + (i + 1) + "/" + this.script_info.length + " ";
            }
            String exStr = "Exporting " + abcStr + cnt + path + " ...";
            this.informListeners("export", exStr);
            this.script_info[i].export(this, abcList, directory, pcode);
        }
    }

    public void dump(OutputStream os) {
        int i;
        PrintStream output = new PrintStream(os);
        this.constants.dump(output);
        for (i = 0; i < this.method_info.length; ++i) {
            output.println("MethodInfo[" + i + "]:" + this.method_info[i].toString(this.constants, new ArrayList<String>()));
        }
        for (i = 0; i < this.metadata_info.length; ++i) {
            output.println("MetadataInfo[" + i + "]:" + this.metadata_info[i].toString(this.constants));
        }
        for (i = 0; i < this.instance_info.length; ++i) {
            output.println("InstanceInfo[" + i + "]:" + this.instance_info[i].toString(this, new ArrayList<String>()));
        }
        for (i = 0; i < this.class_info.length; ++i) {
            output.println("ClassInfo[" + i + "]:" + this.class_info[i].toString(this, new ArrayList<String>()));
        }
        for (i = 0; i < this.script_info.length; ++i) {
            output.println("ScriptInfo[" + i + "]:" + this.script_info[i].toString(this, new ArrayList<String>()));
        }
        for (i = 0; i < this.bodies.length; ++i) {
            output.println("MethodBody[" + i + "]:");
        }
    }

    private String fooString(String orig, boolean firstUppercase, int rndSize) {
        String ret;
        boolean exists;
        block0: do {
            int i;
            exists = false;
            int len = 3 + this.rnd.nextInt(rndSize - 3);
            ret = "";
            for (i = 0; i < len; ++i) {
                String c = "";
                c = i % 2 == 0 ? "" + fooCharacters.charAt(this.rnd.nextInt(fooCharacters.length())) : "" + fooJoinCharacters.charAt(this.rnd.nextInt(fooJoinCharacters.length()));
                if (i == 0 && firstUppercase) {
                    c = c.toUpperCase();
                }
                ret = ret + c;
            }
            for (i = 1; i < this.constants.constant_string.length; ++i) {
                if (!this.constants.constant_string[i].equals(ret)) continue;
                exists = true;
                ++rndSize;
                continue block0;
            }
            if (this.isReserved(ret)) {
                exists = true;
                ++rndSize;
                continue;
            }
            if (!this.deobfuscated.containsValue(ret)) continue;
            exists = true;
            ++rndSize;
        } while (exists);
        this.deobfuscated.put(orig, ret);
        return ret;
    }

    private boolean isReserved(String s) {
        for (String rw : reservedWords) {
            if (!rw.equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean deobfuscateNameSpace(int strIndex) {
        Pattern pat;
        if (strIndex <= 0) {
            return false;
        }
        String s = this.constants.constant_string[strIndex];
        boolean isValid = true;
        if (this.isReserved(s)) {
            isValid = false;
        }
        if (isValid) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                isValid = false;
                break;
            }
        }
        if (!(pat = Pattern.compile("^([" + Pattern.quote(validFirstCharacters) + "]" + "[" + Pattern.quote("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789.:$") + "]*)*$")).matcher(s).matches()) {
            isValid = false;
        }
        if (!isValid) {
            this.constants.constant_string[strIndex] = this.fooString(this.constants.constant_string[strIndex], false, 10);
        }
        return !isValid;
    }

    public boolean deobfuscateName(int strIndex, boolean firstUppercase) {
        Pattern pat;
        if (strIndex <= 0) {
            return false;
        }
        String s = this.constants.constant_string[strIndex];
        boolean isValid = true;
        if (this.isReserved(s)) {
            isValid = false;
        }
        if (!(pat = Pattern.compile("^[" + Pattern.quote(validFirstCharacters) + "]" + "[" + Pattern.quote("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789") + "]*$")).matcher(s).matches()) {
            isValid = false;
        }
        if (isValid) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                isValid = false;
                break;
            }
        }
        if (!isValid) {
            this.constants.constant_string[strIndex] = this.fooString(this.constants.constant_string[strIndex], firstUppercase, 10);
        }
        return !isValid;
    }

    private void checkMultinameUsedInMethod(int multinameIndex, int methodInfo, List<MultinameUsage> ret, int classIndex, int traitIndex, boolean isStatic, boolean isInitializer, Traits traits, int parentTraitIndex) {
        MethodBody body;
        for (int p = 0; p < this.method_info[methodInfo].param_types.length; ++p) {
            if (this.method_info[methodInfo].param_types[p] != multinameIndex) continue;
            ret.add(new MethodParamsMultinameUsage(multinameIndex, classIndex, traitIndex, isStatic, isInitializer, traits, parentTraitIndex));
            break;
        }
        if (this.method_info[methodInfo].ret_type == multinameIndex) {
            ret.add(new MethodReturnTypeMultinameUsage(multinameIndex, classIndex, traitIndex, isStatic, isInitializer, traits, parentTraitIndex));
        }
        if ((body = this.findBody(methodInfo)) != null) {
            this.findMultinameUsageInTraits(body.traits, multinameIndex, isStatic, classIndex, ret, traitIndex);
            for (ABCException e : body.exceptions) {
                if (e.name_index != multinameIndex && e.type_index != multinameIndex) continue;
                ret.add(new MethodBodyMultinameUsage(multinameIndex, classIndex, traitIndex, isStatic, isInitializer, traits, parentTraitIndex));
                return;
            }
            for (AVM2Instruction ins : body.code.code) {
                for (int o = 0; o < ins.definition.operands.length; ++o) {
                    if (ins.definition.operands[o] != 257 || ins.operands[o] != multinameIndex) continue;
                    ret.add(new MethodBodyMultinameUsage(multinameIndex, classIndex, traitIndex, isStatic, isInitializer, traits, parentTraitIndex));
                    return;
                }
            }
        }
    }

    private void findMultinameUsageInTraits(Traits traits, int multinameIndex, boolean isStatic, int classIndex, List<MultinameUsage> ret, int parentTraitIndex) {
        for (int t = 0; t < traits.traits.length; ++t) {
            if (traits.traits[t] instanceof TraitSlotConst) {
                TraitSlotConst tsc = (TraitSlotConst)traits.traits[t];
                if (tsc.name_index == multinameIndex) {
                    ret.add(new ConstVarNameMultinameUsage(multinameIndex, classIndex, t, isStatic, traits, parentTraitIndex));
                }
                if (tsc.type_index == multinameIndex) {
                    ret.add(new ConstVarTypeMultinameUsage(multinameIndex, classIndex, t, isStatic, traits, parentTraitIndex));
                }
            }
            if (!(traits.traits[t] instanceof TraitMethodGetterSetter)) continue;
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)traits.traits[t];
            if (tmgs.name_index == multinameIndex) {
                ret.add(new MethodNameMultinameUsage(multinameIndex, classIndex, t, isStatic, false, traits, parentTraitIndex));
            }
            this.checkMultinameUsedInMethod(multinameIndex, tmgs.method_info, ret, classIndex, t, isStatic, false, traits, parentTraitIndex);
        }
    }

    public List<MultinameUsage> findMultinameUsage(int multinameIndex) {
        ArrayList<MultinameUsage> ret = new ArrayList<MultinameUsage>();
        if (multinameIndex == 0) {
            return ret;
        }
        for (int c = 0; c < this.instance_info.length; ++c) {
            if (this.instance_info[c].name_index == multinameIndex) {
                ret.add(new ClassNameMultinameUsage(multinameIndex, c));
            }
            if (this.instance_info[c].super_index == multinameIndex) {
                ret.add(new ExtendsMultinameUsage(multinameIndex, c));
            }
            for (int i = 0; i < this.instance_info[c].interfaces.length; ++i) {
                if (this.instance_info[c].interfaces[i] != multinameIndex) continue;
                ret.add(new ImplementsMultinameUsage(multinameIndex, c));
            }
            this.checkMultinameUsedInMethod(multinameIndex, this.instance_info[c].iinit_index, ret, c, 0, false, true, null, -1);
            this.checkMultinameUsedInMethod(multinameIndex, this.class_info[c].cinit_index, ret, c, 0, true, true, null, -1);
            this.findMultinameUsageInTraits(this.instance_info[c].instance_traits, multinameIndex, false, c, ret, -1);
            this.findMultinameUsageInTraits(this.class_info[c].static_traits, multinameIndex, true, c, ret, -1);
        }
        block2: for (int m = 1; m < this.constants.constant_multiname.length; ++m) {
            if (this.constants.constant_multiname[m].kind != 29) continue;
            if (this.constants.constant_multiname[m].qname_index == multinameIndex) {
                ret.add(new TypeNameMultinameUsage(m));
                continue;
            }
            for (int mp : this.constants.constant_multiname[m].params) {
                if (mp != multinameIndex) continue;
                ret.add(new TypeNameMultinameUsage(m));
                continue block2;
            }
        }
        return ret;
    }

    public void autoFillAllBodyParams() {
        for (int i = 0; i < this.bodies.length; ++i) {
            this.bodies[i].autoFillStats(this);
        }
    }
}

