/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc;

import com.jpexs.asdec.abc.types.Decimal;
import com.jpexs.asdec.abc.types.InstanceInfo;
import com.jpexs.asdec.abc.types.MethodInfo;
import com.jpexs.asdec.abc.types.Multiname;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.abc.types.ValueKind;
import com.jpexs.asdec.abc.types.traits.Trait;
import com.jpexs.asdec.abc.types.traits.TraitClass;
import com.jpexs.asdec.abc.types.traits.TraitFunction;
import com.jpexs.asdec.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.asdec.abc.types.traits.TraitSlotConst;
import com.jpexs.asdec.abc.types.traits.Traits;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ABCInputStream
extends InputStream {
    private static final int CLASS_PROTECTED_NS = 8;
    private static final int ATTR_METADATA = 4;
    private InputStream is;
    private long bytesRead = 0L;
    private ByteArrayOutputStream bufferOs = null;
    public static boolean DEBUG_READ = false;

    public void startBuffer() {
        this.bufferOs = new ByteArrayOutputStream();
    }

    public byte[] stopBuffer() {
        if (this.bufferOs == null) {
            return new byte[0];
        }
        byte[] ret = this.bufferOs.toByteArray();
        this.bufferOs = null;
        return ret;
    }

    public ABCInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        ++this.bytesRead;
        int i = this.is.read();
        if (DEBUG_READ) {
            System.out.println("Read:0x" + Integer.toHexString(i));
        }
        if (this.bufferOs != null && i != -1) {
            this.bufferOs.write(i);
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int currBytesRead = this.is.read(b);
        this.bytesRead += (long)currBytesRead;
        if (DEBUG_READ) {
            StringBuilder sb = new StringBuilder("Read[");
            sb.append(currBytesRead);
            sb.append('/');
            sb.append(b.length);
            sb.append("]: ");
            for (int jj = 0; jj < currBytesRead; ++jj) {
                sb.append("0x");
                sb.append(Integer.toHexString(b[jj]));
                sb.append(' ');
            }
            System.out.println(sb.toString());
        }
        if (this.bufferOs != null && currBytesRead > 0) {
            this.bufferOs.write(b, 0, currBytesRead);
        }
        return currBytesRead;
    }

    public int readU8() throws IOException {
        return this.read();
    }

    public int readU32() throws IOException {
        boolean nextByte;
        int ret = 0;
        int bytePos = 0;
        int byteCount = 0;
        do {
            int i;
            nextByte = (i = this.read()) >> 7 == 1;
            ret += (i &= 0x7F) << bytePos;
            ++byteCount;
            bytePos += 7;
        } while (nextByte);
        return ret;
    }

    public int readU30() throws IOException {
        return this.readU32();
    }

    public int readS24() throws IOException {
        int ret = this.read() + (this.read() << 8) + (this.read() << 16);
        if (ret >> 23 == 1) {
            ret |= 0xFF000000;
        }
        return ret;
    }

    public int readU16() throws IOException {
        return this.read() + (this.read() << 8);
    }

    public long readS32() throws IOException {
        boolean nextByte;
        long ret = 0L;
        int bytePos = 0;
        int byteCount = 0;
        do {
            int i;
            nextByte = (i = this.read()) >> 7 == 1;
            ret += (long)((i &= 0x7F) << bytePos);
            ++byteCount;
            if ((bytePos += 7) != 35) continue;
            if (ret >> 31 != 1L) break;
            ret = -(ret & Integer.MAX_VALUE);
            break;
        } while (nextByte);
        return ret;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    public final long readLong() throws IOException {
        byte[] readBuffer = this.safeRead(8);
        return ((long)readBuffer[7] << 56) + ((long)(readBuffer[6] & 0xFF) << 48) + ((long)(readBuffer[5] & 0xFF) << 40) + ((long)(readBuffer[4] & 0xFF) << 32) + ((long)(readBuffer[3] & 0xFF) << 24) + (long)((readBuffer[2] & 0xFF) << 16) + (long)((readBuffer[1] & 0xFF) << 8) + (long)(readBuffer[0] & 0xFF);
    }

    public double readDouble() throws IOException {
        long el = this.readLong();
        double ret = Double.longBitsToDouble(el);
        return ret;
    }

    private byte[] safeRead(int count) throws IOException {
        byte[] ret = new byte[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = (byte)this.read();
        }
        return ret;
    }

    public Namespace readNamespace() throws IOException {
        int kind = this.read();
        int name_index = 0;
        for (int k = 0; k < Namespace.nameSpaceKinds.length; ++k) {
            if (Namespace.nameSpaceKinds[k] != kind) continue;
            name_index = this.readU30();
            break;
        }
        return new Namespace(kind, name_index);
    }

    public Multiname readMultiname() throws IOException {
        int kind = this.readU8();
        int namespace_index = -1;
        int name_index = -1;
        int namespace_set_index = -1;
        int qname_index = -1;
        ArrayList<Integer> params = new ArrayList<Integer>();
        if (kind == 7 || kind == 13) {
            namespace_index = this.readU30();
            name_index = this.readU30();
        } else if (kind == 15 || kind == 16) {
            name_index = this.readU30();
        } else if (kind != 17 && kind != 18) {
            if (kind == 9 || kind == 14) {
                name_index = this.readU30();
                namespace_set_index = this.readU30();
            } else if (kind == 27 || kind == 28) {
                namespace_set_index = this.readU30();
            } else if (kind == 29) {
                qname_index = this.readU30();
                int paramsLength = this.readU30();
                for (int i = 0; i < paramsLength; ++i) {
                    params.add(this.readU30());
                }
            } else {
                System.err.println("Unknown kind of Multiname:0x" + Integer.toHexString(kind));
                System.exit(1);
            }
        }
        return new Multiname(kind, name_index, namespace_index, namespace_set_index, qname_index, params);
    }

    public MethodInfo readMethodInfo() throws IOException {
        int i;
        int param_count = this.readU30();
        int ret_type = this.readU30();
        int[] param_types = new int[param_count];
        for (int i2 = 0; i2 < param_count; ++i2) {
            param_types[i2] = this.readU30();
        }
        int name_index = this.readU30();
        int flags = this.read();
        ValueKind[] optional = new ValueKind[]{};
        if ((flags & 8) == 8) {
            int optional_count = this.readU30();
            optional = new ValueKind[optional_count];
            for (i = 0; i < optional_count; ++i) {
                optional[i] = new ValueKind(this.readU30(), this.read());
            }
        }
        int[] param_names = new int[param_count];
        if ((flags & 0x80) == 128) {
            for (i = 0; i < param_count; ++i) {
                param_names[i] = this.readU30();
            }
        }
        return new MethodInfo(param_types, ret_type, name_index, flags, optional, param_names);
    }

    public Trait readTrait() throws IOException {
        Trait trait;
        long pos = this.getPosition();
        this.startBuffer();
        int name_index = this.readU30();
        int kind = this.read();
        int kindType = 0xF & kind;
        int kindFlags = kind >> 4;
        switch (kindType) {
            case 0: 
            case 6: {
                TraitSlotConst t1 = new TraitSlotConst();
                t1.slot_id = this.readU30();
                t1.type_index = this.readU30();
                t1.value_index = this.readU30();
                if (t1.value_index != 0) {
                    t1.value_kind = this.read();
                }
                trait = t1;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                TraitMethodGetterSetter t2 = new TraitMethodGetterSetter();
                t2.disp_id = this.readU30();
                t2.method_info = this.readU30();
                trait = t2;
                break;
            }
            case 4: {
                TraitClass t3 = new TraitClass();
                t3.slot_id = this.readU30();
                t3.class_info = this.readU30();
                trait = t3;
                break;
            }
            case 5: {
                TraitFunction t4 = new TraitFunction();
                t4.slot_index = this.readU30();
                t4.method_info = this.readU30();
                trait = t4;
                break;
            }
            default: {
                throw new IOException("Unknown trait kind:" + kind);
            }
        }
        trait.fileOffset = pos;
        trait.kindType = kindType;
        trait.kindFlags = kindFlags;
        trait.name_index = name_index;
        if ((kindFlags & 4) != 0) {
            int metadata_count = this.readU30();
            trait.metadata = new int[metadata_count];
            for (int i = 0; i < metadata_count; ++i) {
                trait.metadata[i] = this.readU30();
            }
        }
        trait.bytes = this.stopBuffer();
        return trait;
    }

    public Traits readTraits() throws IOException {
        int count = this.readU30();
        Traits traits = new Traits();
        traits.traits = new Trait[count];
        for (int i = 0; i < count; ++i) {
            traits.traits[i] = this.readTrait();
        }
        return traits;
    }

    public byte[] readBytes(int count) throws IOException {
        byte[] ret = new byte[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = (byte)this.read();
        }
        return ret;
    }

    public Decimal readDecimal() throws IOException {
        byte[] data = this.readBytes(16);
        return new Decimal(data);
    }

    public InstanceInfo readInstanceInfo() throws IOException {
        InstanceInfo ret = new InstanceInfo();
        ret.name_index = this.readU30();
        ret.super_index = this.readU30();
        ret.flags = this.read();
        if ((ret.flags & 8) != 0) {
            ret.protectedNS = this.readU30();
        }
        int interfaces_count = this.readU30();
        ret.interfaces = new int[interfaces_count];
        for (int i = 0; i < interfaces_count; ++i) {
            ret.interfaces[i] = this.readU30();
        }
        ret.iinit_index = this.readU30();
        ret.instance_traits = this.readTraits();
        return ret;
    }

    public String readString() throws IOException {
        int length = this.readU30();
        return new String(this.safeRead(length), "utf8");
    }

    public long getPosition() {
        return this.bytesRead;
    }
}

