/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2;

import com.jpexs.asdec.abc.types.Decimal;
import com.jpexs.asdec.abc.types.Multiname;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.abc.types.NamespaceSet;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;

public class ConstantPool {
    public long[] constant_int;
    public long[] constant_uint;
    public double[] constant_double;
    public Decimal[] constant_decimal;
    public String[] constant_string;
    public Namespace[] constant_namespace;
    public NamespaceSet[] constant_namespace_set;
    public Multiname[] constant_multiname;

    public int addInt(long value) {
        this.constant_int = Arrays.copyOf(this.constant_int, this.constant_int.length + 1);
        this.constant_int[this.constant_int.length - 1] = value;
        return this.constant_int.length - 1;
    }

    public int addUInt(long value) {
        this.constant_uint = Arrays.copyOf(this.constant_uint, this.constant_uint.length + 1);
        this.constant_uint[this.constant_uint.length - 1] = value;
        return this.constant_uint.length - 1;
    }

    public int addDouble(double value) {
        this.constant_double = Arrays.copyOf(this.constant_double, this.constant_double.length + 1);
        this.constant_double[this.constant_double.length - 1] = value;
        return this.constant_double.length - 1;
    }

    public int addString(String value) {
        this.constant_string = Arrays.copyOf(this.constant_string, this.constant_string.length + 1);
        this.constant_string[this.constant_string.length - 1] = value;
        return this.constant_string.length - 1;
    }

    public int getIntId(long value) {
        for (int i = 1; i < this.constant_int.length; ++i) {
            if (this.constant_int[i] != value) continue;
            return i;
        }
        return 0;
    }

    public int getUIntId(long value) {
        for (int i = 1; i < this.constant_uint.length; ++i) {
            if (this.constant_uint[i] != value) continue;
            return i;
        }
        return 0;
    }

    public int getDoubleId(double value) {
        for (int i = 1; i < this.constant_double.length; ++i) {
            if (this.constant_double[i] != value) continue;
            return i;
        }
        return 0;
    }

    public int getStringId(String s) {
        for (int i = 1; i < this.constant_string.length; ++i) {
            if (!this.constant_string[i].equals(s)) continue;
            return i;
        }
        return 0;
    }

    public int forceGetStringId(String val) {
        int id = this.getStringId(val);
        if (id == 0) {
            id = this.addString(val);
        }
        return id;
    }

    public int forceGetIntId(long val) {
        int id = this.getIntId(val);
        if (id == 0) {
            id = this.addInt(val);
        }
        return id;
    }

    public int forceGetUIntId(long val) {
        int id = this.getUIntId(val);
        if (id == 0) {
            id = this.addUInt(val);
        }
        return id;
    }

    public int forceGetDoubleId(double val) {
        int id = this.getDoubleId(val);
        if (id == 0) {
            id = this.addDouble(val);
        }
        return id;
    }

    public void dump(OutputStream os) {
        int i;
        PrintStream output = new PrintStream(os);
        String s = "";
        for (i = 1; i < this.constant_int.length; ++i) {
            output.println("INT[" + i + "]=" + this.constant_int[i]);
        }
        for (i = 1; i < this.constant_uint.length; ++i) {
            output.println("UINT[" + i + "]=" + this.constant_uint[i]);
        }
        for (i = 1; i < this.constant_double.length; ++i) {
            output.println("Double[" + i + "]=" + this.constant_double[i]);
        }
        for (i = 1; i < this.constant_string.length; ++i) {
            output.println("String[" + i + "]=" + this.constant_string[i]);
        }
        for (i = 1; i < this.constant_namespace.length; ++i) {
            output.println("Namespace[" + i + "]=" + this.constant_namespace[i].toString(this));
        }
        for (i = 1; i < this.constant_namespace_set.length; ++i) {
            output.println("NamespaceSet[" + i + "]=" + this.constant_namespace_set[i].toString(this));
        }
        for (i = 1; i < this.constant_multiname.length; ++i) {
            output.println("Multiname[" + i + "]=" + this.constant_multiname[i].toString(this, new ArrayList<String>()));
        }
    }
}

