/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.flowgraph;

import java.util.ArrayList;
import java.util.List;

public class GraphPart {
    public int start = 0;
    public int end = 0;
    public int instanceCount = 0;
    public List<GraphPart> nextParts = new ArrayList<GraphPart>();
    public int posX = -1;
    public int posY = -1;

    public GraphPart(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public String toString() {
        if (this.end < this.start) {
            return "<->";
        }
        return "" + (this.start + 1) + "-" + (this.end + 1) + (this.instanceCount > 1 ? "(" + this.instanceCount + " links)" : "");
    }

    public boolean containsIP(int ip) {
        return ip >= this.start && ip <= this.end;
    }

    private boolean containsPart(GraphPart part, GraphPart what, List<GraphPart> used) {
        if (used.contains(part)) {
            return false;
        }
        used.add(part);
        for (GraphPart subpart : part.nextParts) {
            if (subpart == what) {
                return true;
            }
            if (!this.containsPart(subpart, what, used)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPart(GraphPart what) {
        return this.containsPart(this, what, new ArrayList<GraphPart>());
    }
}

