/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.instructions;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.LocalDataArea;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.treemodel.FullMultinameTreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.abc.types.MethodBody;
import com.jpexs.asdec.abc.types.MethodInfo;
import com.jpexs.asdec.helpers.Highlighting;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class InstructionDefinition {
    public int[] operands;
    public String instructionName = "";
    public int instructionCode = 0;

    protected String hilighOffset(String text, long offset) {
        return Highlighting.hilighOffset(text, offset);
    }

    public InstructionDefinition(int instructionCode, String instructionName, int[] operands) {
        this.instructionCode = instructionCode;
        this.instructionName = instructionName;
        this.operands = operands;
    }

    public String toString() {
        String s = this.instructionName;
        for (int i = 0; i < this.operands.length; ++i) {
            if ((this.operands[i] & 0xFF00) == 256) {
                s = s + " U30";
            }
            if ((this.operands[i] & 0xFF00) == 512) {
                s = s + " U8";
            }
            if ((this.operands[i] & 0xFF00) == 1280) {
                s = s + " BYTE";
            }
            if ((this.operands[i] & 0xFF00) == 768) {
                s = s + " S24";
            }
            if ((this.operands[i] & 0xFF00) != 1024) continue;
            s = s + " U30 S24,[S24]...";
        }
        return s;
    }

    public void execute(LocalDataArea lda, ConstantPool constants, List arguments) {
        throw new UnsupportedOperationException("Instruction " + this.instructionName + " not implemented");
    }

    public void translate(boolean isStatic, int classIndex, HashMap<Integer, TreeItem> localRegs, Stack<TreeItem> stack, Stack<TreeItem> scopeStack, ConstantPool constants, AVM2Instruction ins, MethodInfo[] method_info, List<TreeItem> output, MethodBody body, ABC abc, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
    }

    protected FullMultinameTreeItem resolveMultiname(Stack<TreeItem> stack, ConstantPool constants, int multinameIndex, AVM2Instruction ins) {
        TreeItem ns = null;
        TreeItem name = null;
        if (constants.constant_multiname[multinameIndex].needsName()) {
            name = stack.pop();
        }
        if (constants.constant_multiname[multinameIndex].needsNs()) {
            ns = stack.pop();
        }
        return new FullMultinameTreeItem(ins, multinameIndex, name, ns);
    }

    protected int resolvedCount(ConstantPool constants, int multinameIndex) {
        int pos = 0;
        if (constants.constant_multiname[multinameIndex].needsNs()) {
            ++pos;
        }
        if (constants.constant_multiname[multinameIndex].needsName()) {
            ++pos;
        }
        return pos;
    }

    protected String resolveMultinameNoPop(int pos, Stack<TreeItem> stack, ConstantPool constants, int multinameIndex, AVM2Instruction ins, List<String> fullyQualifiedNames) {
        String ns = "";
        if (constants.constant_multiname[multinameIndex].needsNs()) {
            ns = "[" + stack.get(pos) + "]";
            ++pos;
        }
        String name = constants.constant_multiname[multinameIndex].needsName() ? ((TreeItem)stack.get(pos)).toString() : this.hilighOffset(constants.constant_multiname[multinameIndex].getName(constants, fullyQualifiedNames), ins.offset);
        return name + ns;
    }

    public int getStackDelta(AVM2Instruction ins, ABC abc) {
        return 0;
    }

    public int getScopeStackDelta(AVM2Instruction ins, ABC abc) {
        return 0;
    }
}

