/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.instructions.arithmetic;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.LocalDataArea;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.operations.MultiplyTreeItem;
import com.jpexs.asdec.abc.types.MethodBody;
import com.jpexs.asdec.abc.types.MethodInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class MultiplyIns
extends InstructionDefinition {
    public MultiplyIns() {
        super(162, "multiply", new int[0]);
    }

    @Override
    public void execute(LocalDataArea lda, ConstantPool constants, List arguments) {
        Object o1 = lda.operandStack.pop();
        Object o2 = lda.operandStack.pop();
        if (o1 instanceof Long && o2 instanceof Long) {
            Long ret = new Long((Long)o1 * (Long)o2);
            lda.operandStack.push(ret);
        } else if (o1 instanceof Double && o2 instanceof Double) {
            Double ret = new Double((Double)o1 * (Double)o2);
            lda.operandStack.push(ret);
        } else if (o1 instanceof Long && o2 instanceof Double) {
            Double ret = new Double((double)((Long)o1).longValue() * (Double)o2);
            lda.operandStack.push(ret);
        } else if (o1 instanceof Double && o2 instanceof Long) {
            Double ret = new Double((Double)o1 * (double)((Long)o2).longValue());
            lda.operandStack.push(ret);
        } else {
            throw new RuntimeException("Cannot multiply");
        }
    }

    @Override
    public void translate(boolean isStatic, int classIndex, HashMap<Integer, TreeItem> localRegs, Stack<TreeItem> stack, Stack<TreeItem> scopeStack, ConstantPool constants, AVM2Instruction ins, MethodInfo[] method_info, List<TreeItem> output, MethodBody body, ABC abc, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        TreeItem v2 = stack.pop();
        TreeItem v1 = stack.pop();
        stack.push(new MultiplyTreeItem(ins, v1, v2));
    }

    @Override
    public int getStackDelta(AVM2Instruction ins, ABC abc) {
        return -1;
    }
}

