/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.parser;

import com.jpexs.asdec.abc.avm2.AVM2Code;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.asdec.abc.avm2.parser.Flasm3Lexer;
import com.jpexs.asdec.abc.avm2.parser.MissingSymbolHandler;
import com.jpexs.asdec.abc.avm2.parser.ParseException;
import com.jpexs.asdec.abc.avm2.parser.ParsedSymbol;
import com.jpexs.asdec.abc.types.ABCException;
import com.jpexs.asdec.abc.types.MethodBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ASM3Parser {
    public static AVM2Code parse(InputStream is, ConstantPool constants, MethodBody body) throws IOException, ParseException {
        return ASM3Parser.parse(is, constants, null, body);
    }

    public static AVM2Code parse(InputStream is, ConstantPool constants, MissingSymbolHandler missingHandler, MethodBody body) throws IOException, ParseException {
        ParsedSymbol symb;
        AVM2Code code = new AVM2Code();
        ArrayList<OffsetItem> offsetItems = new ArrayList<OffsetItem>();
        ArrayList<LabelItem> labelItems = new ArrayList<LabelItem>();
        ArrayList<ABCException> exceptions = new ArrayList<ABCException>();
        ArrayList<Integer> exceptionIndices = new ArrayList<Integer>();
        int offset = 0;
        Flasm3Lexer lexer = new Flasm3Lexer(is);
        AVM2Instruction lastIns = null;
        do {
            symb = lexer.yylex();
            if (symb.type == 10) {
                int exIndex = (Integer)symb.value;
                int listIndex = exceptionIndices.indexOf(exIndex);
                if (listIndex == -1) {
                    throw new ParseException("Undefinex exception index", lexer.yyline());
                }
                ((ABCException)exceptions.get((int)listIndex)).start = offset;
                continue;
            }
            if (symb.type == 11) {
                int exIndex = (Integer)symb.value;
                int listIndex = exceptionIndices.indexOf(exIndex);
                if (listIndex == -1) {
                    throw new ParseException("Undefinex exception index", lexer.yyline());
                }
                ((ABCException)exceptions.get((int)listIndex)).end = offset;
                continue;
            }
            if (symb.type == 12) {
                int exIndex = (Integer)symb.value;
                int listIndex = exceptionIndices.indexOf(exIndex);
                if (listIndex == -1) {
                    throw new ParseException("Undefinex exception index", lexer.yyline());
                }
                ((ABCException)exceptions.get((int)listIndex)).target = offset;
                continue;
            }
            if (symb.type == 7) break;
            if (symb.type == 9) {
                if (lastIns == null) continue;
                lastIns.comment = (String)symb.value;
                continue;
            }
            if (symb.type == 3) {
                if (((String)symb.value).toLowerCase().equals("exception")) {
                    ParsedSymbol exIndex = lexer.yylex();
                    if (exIndex.type != 4) {
                        throw new ParseException("Index expected", lexer.yyline());
                    }
                    ParsedSymbol exName = lexer.yylex();
                    if (exName.type != 2) {
                        throw new ParseException("Multiname expected", lexer.yyline());
                    }
                    ParsedSymbol exType = lexer.yylex();
                    if (exType.type != 2) {
                        throw new ParseException("Multiname expected", lexer.yyline());
                    }
                    ABCException ex = new ABCException();
                    ex.name_index = (int)((Long)exName.value).longValue();
                    ex.type_index = (int)((Long)exType.value).longValue();
                    exceptions.add(ex);
                    exceptionIndices.add((int)((Long)exIndex.value).longValue());
                    continue;
                }
                boolean insFound = false;
                for (InstructionDefinition def : AVM2Code.instructionSet) {
                    if (!def.instructionName.equals((String)symb.value)) continue;
                    insFound = true;
                    ArrayList<Integer> operandsList = new ArrayList<Integer>();
                    block12: for (int i = 0; i < def.operands.length; ++i) {
                        ParsedSymbol parsedOperand = lexer.yylex();
                        switch (def.operands[i]) {
                            case 257: {
                                if (parsedOperand.type == 2) {
                                    operandsList.add((int)((Long)parsedOperand.value).longValue());
                                    continue block12;
                                }
                                throw new ParseException("Multiname expected", lexer.yyline());
                            }
                            case 260: {
                                if (parsedOperand.type == 1) {
                                    int sid = constants.getStringId((String)parsedOperand.value);
                                    if (sid == 0) {
                                        if (missingHandler != null && missingHandler.missingString((String)parsedOperand.value)) {
                                            sid = constants.addString((String)parsedOperand.value);
                                        } else {
                                            throw new ParseException("Unknown String", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(sid);
                                    continue block12;
                                }
                                throw new ParseException("String expected", lexer.yyline());
                            }
                            case 270: {
                                int iid;
                                if (parsedOperand.type == 4) {
                                    long intVal = (Long)parsedOperand.value;
                                    iid = constants.getIntId(intVal);
                                    if (iid == 0) {
                                        if (missingHandler != null && missingHandler.missingInt(intVal)) {
                                            iid = constants.addInt(intVal);
                                        } else {
                                            throw new ParseException("Unknown int", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(iid);
                                    continue block12;
                                }
                                throw new ParseException("Integer expected", lexer.yyline());
                            }
                            case 271: {
                                int iid;
                                if (parsedOperand.type == 4) {
                                    long intVal = (Long)parsedOperand.value;
                                    iid = constants.getUIntId(intVal);
                                    if (iid == 0) {
                                        if (missingHandler != null && missingHandler.missingUInt(intVal)) {
                                            iid = constants.addUInt(intVal);
                                        } else {
                                            throw new ParseException("Unknown uint", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(iid);
                                    continue block12;
                                }
                                throw new ParseException("Integer expected", lexer.yyline());
                            }
                            case 272: {
                                if (parsedOperand.type == 4 || parsedOperand.type == 5) {
                                    int did;
                                    double doubleVal = 0.0;
                                    if (parsedOperand.type == 4) {
                                        doubleVal = ((Long)parsedOperand.value).longValue();
                                    }
                                    if (parsedOperand.type == 5) {
                                        doubleVal = (Double)parsedOperand.value;
                                    }
                                    if ((did = constants.getDoubleId(doubleVal)) == 0) {
                                        if (missingHandler != null && missingHandler.missingDouble(doubleVal)) {
                                            did = constants.addDouble(doubleVal);
                                        } else {
                                            throw new ParseException("Unknown double", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(did);
                                    continue block12;
                                }
                                throw new ParseException("Float value expected", lexer.yyline());
                            }
                            case 779: {
                                if (parsedOperand.type == 6) {
                                    offsetItems.add(new OffsetItem((String)parsedOperand.value, code.code.size(), i));
                                    operandsList.add(0);
                                    continue block12;
                                }
                                throw new ParseException("Offset expected", lexer.yyline());
                            }
                            case 786: {
                                if (parsedOperand.type == 6) {
                                    offsetItems.add(new CaseOffsetItem((String)parsedOperand.value, code.code.size(), i));
                                    operandsList.add(0);
                                    continue block12;
                                }
                                throw new ParseException("Offset expected", lexer.yyline());
                            }
                            case 1024: {
                                if (parsedOperand.type == 4) {
                                    int patCount = (int)((Long)parsedOperand.value).longValue();
                                    operandsList.add(patCount);
                                    for (int c = 0; c <= patCount; ++c) {
                                        parsedOperand = lexer.yylex();
                                        if (parsedOperand.type != 6) {
                                            throw new ParseException("Offset expected", lexer.yyline());
                                        }
                                        offsetItems.add(new CaseOffsetItem((String)parsedOperand.value, code.code.size(), i + (c + 1)));
                                        operandsList.add(0);
                                    }
                                    continue block12;
                                }
                                throw new ParseException("Case count expected", lexer.yyline());
                            }
                            default: {
                                if (parsedOperand.type == 4) {
                                    operandsList.add((int)((Long)parsedOperand.value).longValue());
                                    continue block12;
                                }
                                throw new ParseException("Integer expected", lexer.yyline());
                            }
                        }
                    }
                    int[] operands = new int[operandsList.size()];
                    for (int i = 0; i < operandsList.size(); ++i) {
                        operands[i] = (Integer)operandsList.get(i);
                    }
                    lastIns = new AVM2Instruction(offset, def, operands, new byte[0]);
                    code.code.add(lastIns);
                    offset += lastIns.getBytes().length;
                    break;
                }
                if (insFound) continue;
                throw new ParseException("Invalid instruction name:" + (String)symb.value, lexer.yyline());
            }
            if (symb.type == 8) {
                labelItems.add(new LabelItem((String)symb.value, offset));
                continue;
            }
            throw new ParseException("Unexpected symbol", lexer.yyline());
        } while (symb.type != 7);
        code.compact();
        for (OffsetItem oi : offsetItems) {
            for (LabelItem li : labelItems) {
                if (!oi.label.equals(li.label)) continue;
                AVM2Instruction ins = code.code.get((int)oi.insPosition);
                int relOffset = oi instanceof CaseOffsetItem ? li.offset - (int)ins.offset : li.offset - ((int)ins.offset + ins.getBytes().length);
                ins.operands[oi.insOperandIndex] = relOffset;
            }
        }
        body.exceptions = new ABCException[exceptions.size()];
        for (int e = 0; e < exceptions.size(); ++e) {
            body.exceptions[e] = (ABCException)exceptions.get(e);
        }
        return code;
    }

    private static class LabelItem {
        public String label = "";
        public int offset;

        public LabelItem(String label, int offset) {
            this.label = label;
            this.offset = offset;
        }
    }

    private static class CaseOffsetItem
    extends OffsetItem {
        public CaseOffsetItem(String label, long insOffset, int insOperandIndex) {
            super(label, insOffset, insOperandIndex);
        }
    }

    private static class OffsetItem {
        public String label = "";
        public long insPosition;
        public int insOperandIndex;

        public OffsetItem(String label, long insOffset, int insOperandIndex) {
            this.label = label;
            this.insPosition = insOffset;
            this.insOperandIndex = insOperandIndex;
        }
    }
}

