/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.treemodel;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import java.util.HashMap;
import java.util.List;

public class CallTreeItem
extends TreeItem {
    public TreeItem receiver;
    public TreeItem function;
    public List<TreeItem> arguments;

    public CallTreeItem(AVM2Instruction instruction, TreeItem receiver, TreeItem function, List<TreeItem> arguments) {
        super(instruction, 0);
        this.receiver = receiver;
        this.function = function;
        this.arguments = arguments;
    }

    @Override
    public String toString(ConstantPool constants, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        String args = "";
        for (int a = 0; a < this.arguments.size(); ++a) {
            if (a > 0) {
                args = args + ",";
            }
            args = args + this.arguments.get(a).toString(constants, localRegNames, fullyQualifiedNames);
        }
        String fstr = this.function.toString(constants, localRegNames, fullyQualifiedNames);
        if (this.function.precedence > this.precedence) {
            fstr = "(" + fstr + ")";
        }
        return fstr + this.hilight("(") + args + this.hilight(")");
    }
}

