/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.treemodel.clauses;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.treemodel.ContinueTreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.clauses.Block;
import com.jpexs.asdec.abc.avm2.treemodel.clauses.LoopTreeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SwitchTreeItem
extends LoopTreeItem
implements Block {
    public TreeItem switchedObject;
    public List<TreeItem> caseValues;
    public List<List<TreeItem>> caseCommands;
    public List<TreeItem> defaultCommands;

    public SwitchTreeItem(AVM2Instruction instruction, int switchBreak, TreeItem switchedObject, List<TreeItem> caseValues, List<List<TreeItem>> caseCommands, List<TreeItem> defaultCommands) {
        super(instruction, switchBreak, -1);
        this.switchedObject = switchedObject;
        this.caseValues = caseValues;
        this.caseCommands = caseCommands;
        this.defaultCommands = defaultCommands;
    }

    @Override
    public String toString(ConstantPool constants, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        String ret = "";
        ret = ret + "loop" + this.loopBreak + ":\r\n";
        ret = ret + this.hilight("switch(") + this.switchedObject.toString(constants, localRegNames, fullyQualifiedNames) + this.hilight(")") + "\r\n{\r\n";
        for (int i = 0; i < this.caseValues.size(); ++i) {
            ret = ret + "case " + this.caseValues.get(i).toString(constants, localRegNames, fullyQualifiedNames) + ":\r\n";
            ret = ret + "/*IDENTOPEN*/\r\n";
            for (int j = 0; j < this.caseCommands.get(i).size(); ++j) {
                ret = ret + this.caseCommands.get(i).get(j).toStringSemicoloned(constants, localRegNames, fullyQualifiedNames) + "\r\n";
            }
            ret = ret + "/*IDENTCLOSE*/\r\n";
        }
        if (this.defaultCommands.size() > 0) {
            ret = ret + this.hilight("default") + ":\r\n";
            ret = ret + "/*IDENTOPEN*/\r\n";
            for (int j = 0; j < this.defaultCommands.size(); ++j) {
                ret = ret + this.defaultCommands.get(j).toStringSemicoloned(constants, localRegNames, fullyQualifiedNames) + "\r\n";
            }
            ret = ret + "/*IDENTCLOSE*/\r\n";
        }
        ret = ret + this.hilight("}") + "\r\n";
        ret = ret + ":loop" + this.loopBreak;
        return ret;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public List<ContinueTreeItem> getContinues() {
        ArrayList<ContinueTreeItem> ret = new ArrayList<ContinueTreeItem>();
        for (List<TreeItem> onecase : this.caseCommands) {
            for (TreeItem ti : onecase) {
                if (ti instanceof ContinueTreeItem) {
                    ret.add((ContinueTreeItem)ti);
                }
                if (!(ti instanceof Block)) continue;
                ret.addAll(((Block)((Object)ti)).getContinues());
            }
        }
        for (TreeItem ti : this.defaultCommands) {
            if (ti instanceof ContinueTreeItem) {
                ret.add((ContinueTreeItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        return ret;
    }
}

