/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.gui.ABCComboBoxModel;
import com.jpexs.asdec.abc.gui.ClassesListTree;
import com.jpexs.asdec.abc.gui.DecompiledEditorPane;
import com.jpexs.asdec.abc.gui.DetailPanel;
import com.jpexs.asdec.abc.gui.TraitsList;
import com.jpexs.asdec.abc.gui.UsageFrame;
import com.jpexs.asdec.abc.gui.tablemodels.DecimalTableModel;
import com.jpexs.asdec.abc.gui.tablemodels.DoubleTableModel;
import com.jpexs.asdec.abc.gui.tablemodels.IntTableModel;
import com.jpexs.asdec.abc.gui.tablemodels.MultinameTableModel;
import com.jpexs.asdec.abc.gui.tablemodels.NamespaceSetTableModel;
import com.jpexs.asdec.abc.gui.tablemodels.NamespaceTableModel;
import com.jpexs.asdec.abc.gui.tablemodels.StringTableModel;
import com.jpexs.asdec.abc.gui.tablemodels.UIntTableModel;
import com.jpexs.asdec.gui.View;
import com.jpexs.asdec.tags.DoABCTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jsyntaxpane.DefaultSyntaxKit;

public class ABCPanel
extends JPanel
implements ItemListener,
ActionListener {
    public TraitsList navigator;
    public ClassesListTree classTree;
    public ABC abc;
    public List<DoABCTag> list;
    public JComboBox abcComboBox;
    public int listIndex = 0;
    public DecompiledEditorPane decompiledTextArea;
    public JScrollPane decompiledScrollPane;
    public JSplitPane splitPaneDecompiledVSDetail;
    public JSplitPane splitPaneTreeVSNavigator;
    public JSplitPane splitPaneTreeNavVSDecompiledDetail;
    private JTable constantTable;
    public JComboBox constantTypeList;
    public JLabel asmLabel = new JLabel("P-code source (editable)");
    public JLabel decLabel = new JLabel("ActionScript source");
    public DetailPanel detailPanel;
    public JTextField filterField = new JTextField("");

    private JTable autoResizeColWidth(JTable table, TableModel model) {
        table.setAutoResizeMode(0);
        table.setModel(model);
        int margin = 5;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int vColIndex = i;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(vColIndex);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            for (int r = 0; r < table.getRowCount(); ++r) {
                renderer = table.getCellRenderer(r, vColIndex);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width += 2 * margin);
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    public void setAbc(ABC abc) {
        this.abc = abc;
        this.updateConstList();
    }

    public void updateConstList() {
        switch (this.constantTypeList.getSelectedIndex()) {
            case 0: {
                this.autoResizeColWidth(this.constantTable, new UIntTableModel(this.abc));
                break;
            }
            case 1: {
                this.autoResizeColWidth(this.constantTable, new IntTableModel(this.abc));
                break;
            }
            case 2: {
                this.autoResizeColWidth(this.constantTable, new DoubleTableModel(this.abc));
                break;
            }
            case 3: {
                this.autoResizeColWidth(this.constantTable, new DecimalTableModel(this.abc));
                break;
            }
            case 4: {
                this.autoResizeColWidth(this.constantTable, new StringTableModel(this.abc));
                break;
            }
            case 5: {
                this.autoResizeColWidth(this.constantTable, new NamespaceTableModel(this.abc));
                break;
            }
            case 6: {
                this.autoResizeColWidth(this.constantTable, new NamespaceSetTableModel(this.abc));
                break;
            }
            case 7: {
                this.autoResizeColWidth(this.constantTable, new MultinameTableModel(this.abc));
            }
        }
    }

    public void switchAbc(int index) {
        this.listIndex = index;
        if (index == -1) {
            this.classTree.setDoABCTags(this.list);
        } else {
            ArrayList<DoABCTag> oneList = new ArrayList<DoABCTag>();
            oneList.add(this.list.get(index));
            this.abc = this.list.get((int)index).abc;
            this.classTree.setDoABCTags(oneList);
        }
        this.updateConstList();
    }

    public void initSplits() {
        this.splitPaneTreeVSNavigator.setDividerLocation(this.splitPaneTreeVSNavigator.getHeight() / 2);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ABCPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.splitPaneTreeNavVSDecompiledDetail.setDividerLocation(this.splitPaneTreeNavVSDecompiledDetail.getWidth() * 1 / 3);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ABCPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.splitPaneDecompiledVSDetail.setDividerLocation(this.splitPaneDecompiledVSDetail.getWidth() * 1 / 2);
    }

    public ABCPanel(List<DoABCTag> list) {
        DefaultSyntaxKit.initKit();
        this.list = list;
        if (list.size() > 0) {
            this.abc = list.get((int)this.listIndex).abc;
        }
        this.setLayout(new BorderLayout());
        this.decompiledTextArea = new DecompiledEditorPane();
        this.decompiledScrollPane = new JScrollPane(this.decompiledTextArea);
        this.detailPanel = new DetailPanel();
        JPanel panB = new JPanel();
        panB.setLayout(new BorderLayout());
        panB.add((Component)this.decompiledScrollPane, "Center");
        panB.add((Component)this.decLabel, "North");
        this.decLabel.setHorizontalAlignment(0);
        this.decLabel.setBorder(new BevelBorder(0));
        this.splitPaneDecompiledVSDetail = new JSplitPane(1, panB, this.detailPanel);
        this.splitPaneDecompiledVSDetail.setResizeWeight(0.5);
        this.splitPaneDecompiledVSDetail.setContinuousLayout(true);
        this.decompiledTextArea.setContentType("text/actionscript");
        JPanel pan2 = new JPanel();
        pan2.setLayout(new BorderLayout());
        this.abcComboBox = new JComboBox(new ABCComboBoxModel(list));
        pan2.add(this.abcComboBox, "North");
        this.navigator = new TraitsList();
        this.navigator.setABC(list, this.abc);
        JPanel navPanel = new JPanel(new BorderLayout());
        JLabel traitsLabel = new JLabel("Traits");
        navPanel.add((Component)traitsLabel, "North");
        traitsLabel.setBorder(new BevelBorder(0));
        navPanel.add((Component)new JScrollPane(this.navigator), "Center");
        Main.startWork("Building script tree...");
        this.filterField.setActionCommand("FILTERSCRIPT");
        this.filterField.addActionListener(this);
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warn();
            }

            public void warn() {
                ABCPanel.this.doFilter();
            }
        });
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        this.classTree = new ClassesListTree(list);
        treePanel.add((Component)new JScrollPane(this.classTree), "Center");
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BorderLayout());
        searchPanel.add((Component)this.filterField, "Center");
        JLabel picLabel = new JLabel(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/search.png")));
        searchPanel.add((Component)picLabel, "East");
        treePanel.add((Component)searchPanel, "North");
        this.splitPaneTreeVSNavigator = new JSplitPane(0, treePanel, navPanel);
        this.splitPaneTreeVSNavigator.setResizeWeight(0.5);
        this.splitPaneTreeVSNavigator.setContinuousLayout(true);
        Main.startWork("Creating window...");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Scripts", this.splitPaneTreeVSNavigator);
        pan2.add((Component)tabbedPane, "Center");
        this.abcComboBox.addItemListener(this);
        this.splitPaneTreeNavVSDecompiledDetail = new JSplitPane(1, pan2, this.splitPaneDecompiledVSDetail);
        this.splitPaneTreeNavVSDecompiledDetail.setResizeWeight(0.0);
        this.splitPaneTreeNavVSDecompiledDetail.setContinuousLayout(true);
        this.add((Component)this.splitPaneTreeNavVSDecompiledDetail, "Center");
        JPanel panConstants = new JPanel();
        panConstants.setLayout(new BorderLayout());
        this.constantTypeList = new JComboBox<String>(new String[]{"UINT", "INT", "DOUBLE", "DECIMAL", "STRING", "NAMESPACE", "NAMESPACESET", "MULTINAME"});
        this.constantTable = new JTable();
        if (this.abc != null) {
            this.autoResizeColWidth(this.constantTable, new UIntTableModel(this.abc));
        }
        this.constantTable.setAutoCreateRowSorter(true);
        final List<DoABCTag> inlist = list;
        this.constantTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ABCPanel.this.constantTypeList.getSelectedIndex() == 7) {
                    int rowIndex = ABCPanel.this.constantTable.getSelectedRow();
                    if (rowIndex == -1) {
                        return;
                    }
                    int multinameIndex = ABCPanel.this.constantTable.convertRowIndexToModel(rowIndex);
                    if (multinameIndex > 0) {
                        UsageFrame usageFrame = new UsageFrame(inlist, ABCPanel.this.abc, multinameIndex);
                        usageFrame.setVisible(true);
                    }
                }
            }
        });
        this.constantTypeList.addItemListener(this);
        panConstants.add((Component)this.constantTypeList, "North");
        panConstants.add((Component)new JScrollPane(this.constantTable), "Center");
        tabbedPane.addTab("Constants", panConstants);
    }

    public void doFilter() {
        this.classTree.applyFilter(this.filterField.getText());
    }

    public void reload() {
        this.switchAbc(this.listIndex - 1);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int index;
        if (e.getSource() == this.abcComboBox) {
            index = ((JComboBox)e.getSource()).getSelectedIndex();
            if (index == -1) {
                return;
            }
            this.switchAbc(index - 1);
        }
        if (e.getSource() == this.constantTypeList) {
            index = ((JComboBox)e.getSource()).getSelectedIndex();
            if (index == -1) {
                return;
            }
            this.updateConstList();
        }
    }

    public void display() {
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("FILTERSCRIPT")) {
            this.doFilter();
        }
    }
}

