/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.abc.gui.ClassesListTreeModel;
import com.jpexs.asdec.abc.gui.TreeElement;
import com.jpexs.asdec.abc.gui.TreeLeafScript;
import com.jpexs.asdec.abc.gui.TreeVisitor;
import com.jpexs.asdec.abc.types.traits.Trait;
import com.jpexs.asdec.abc.types.traits.TraitClass;
import com.jpexs.asdec.tags.DoABCTag;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ClassesListTree
extends JTree
implements TreeSelectionListener {
    private List<DoABCTag> abcList;
    private HashMap<String, TreeLeafScript> treeList;

    public void selectClass(int classIndex) {
        ClassesListTreeModel model = (ClassesListTreeModel)this.getModel();
        TreeElement selectedElement = model.getElementByClassIndex(classIndex);
        TreePath treePath = selectedElement.getTreePath();
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    public ClassesListTree(List<DoABCTag> list) {
        this.abcList = list;
        this.treeList = this.getTreeList(list);
        this.setModel(new ClassesListTreeModel(this.treeList));
        this.addTreeSelectionListener(this);
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
        ClassLoader cldr = this.getClass().getClassLoader();
        URL imageURL = cldr.getResource("com/jpexs/asdec/gui/graphics/as16.png");
        ImageIcon leafIcon = new ImageIcon(imageURL);
        treeRenderer.setLeafIcon(leafIcon);
        this.setCellRenderer(treeRenderer);
    }

    public List<TreeLeafScript> getSelectedScripts() {
        TreeSelectionModel tsm = this.getSelectionModel();
        final ArrayList<TreeLeafScript> selectedScripts = new ArrayList<TreeLeafScript>();
        TreePath[] tps = tsm.getSelectionPaths();
        if (tps == null) {
            return selectedScripts;
        }
        for (TreePath tp : tps) {
            TreeElement te = (TreeElement)tp.getLastPathComponent();
            if (te.isLeaf()) {
                Object item = te.getItem();
                if (!(item instanceof TreeLeafScript)) continue;
                selectedScripts.add((TreeLeafScript)item);
                continue;
            }
            TreeVisitor tvi = new TreeVisitor(){

                @Override
                public void onBranch(TreeElement branch) {
                }

                @Override
                public void onLeaf(TreeElement leaf) {
                    Object item = leaf.getItem();
                    if (item instanceof TreeLeafScript) {
                        selectedScripts.add((TreeLeafScript)item);
                    }
                }
            };
            te.visitBranches(tvi);
            te.visitLeafs(tvi);
        }
        return selectedScripts;
    }

    public HashMap<String, TreeLeafScript> getTreeList(List<DoABCTag> list) {
        HashMap<String, TreeLeafScript> ret = new HashMap<String, TreeLeafScript>();
        for (DoABCTag tag : list) {
            for (int i = 0; i < tag.abc.script_info.length; ++i) {
                String path = tag.abc.script_info[i].getPath(tag.abc);
                ret.put(path, new TreeLeafScript(tag.abc, i));
            }
        }
        return ret;
    }

    public void setDoABCTags(List<DoABCTag> list) {
        this.abcList = list;
        this.treeList = this.getTreeList(list);
        this.setModel(new ClassesListTreeModel(this.treeList));
    }

    public void applyFilter(String filter) {
        this.setModel(new ClassesListTreeModel(this.treeList, filter));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (Main.isWorking()) {
            return;
        }
        TreeElement tp = (TreeElement)this.getLastSelectedPathComponent();
        if (tp == null) {
            return;
        }
        Object item = tp.getItem();
        if (item instanceof TreeLeafScript) {
            final TreeLeafScript scriptLeaf = (TreeLeafScript)item;
            if (!Main.isWorking()) {
                Main.startWork("Decompiling...");
                new Thread(){

                    @Override
                    public void run() {
                        int classIndex = -1;
                        for (Trait t : scriptLeaf.abc.script_info[scriptLeaf.scriptIndex].traits.traits) {
                            if (!(t instanceof TraitClass)) continue;
                            classIndex = ((TraitClass)t).class_info;
                            break;
                        }
                        Main.mainFrame.abcPanel.navigator.setABC(ClassesListTree.this.abcList, scriptLeaf.abc);
                        Main.mainFrame.abcPanel.navigator.setClassIndex(classIndex);
                        Main.mainFrame.abcPanel.setAbc(scriptLeaf.abc);
                        Main.mainFrame.abcPanel.decompiledTextArea.setScript(scriptLeaf.abc.script_info[scriptLeaf.scriptIndex], scriptLeaf.abc, ClassesListTree.this.abcList);
                        Main.mainFrame.abcPanel.decompiledTextArea.setClassIndex(classIndex);
                        Main.mainFrame.abcPanel.detailPanel.methodTraitPanel.methodCodePanel.sourceTextArea.setText("");
                        Main.stopWork();
                    }
                }.start();
            }
        }
    }
}

