/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.abc.gui.ClassIndexVisitor;
import com.jpexs.asdec.abc.gui.Tree;
import com.jpexs.asdec.abc.gui.TreeElement;
import com.jpexs.asdec.abc.gui.TreeLeafScript;
import java.util.HashMap;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ClassesListTreeModel
implements TreeModel {
    private Tree classTree = new Tree();

    public ClassesListTreeModel(HashMap<String, TreeLeafScript> list) {
        this(list, null);
    }

    public ClassesListTreeModel(HashMap<String, TreeLeafScript> list, String filter) {
        for (String path : list.keySet()) {
            if (filter != null && !filter.equals("") && !path.contains(filter)) continue;
            String nsName = path.substring(path.lastIndexOf(".") + 1);
            String packageName = path.substring(0, path.lastIndexOf("."));
            this.classTree.add(nsName, packageName, list.get(path));
        }
    }

    public Object getItemByPath(String fullPath) {
        TreeElement elem = this.classTree.get(fullPath);
        if (elem == null) {
            return -1;
        }
        return elem.getItem();
    }

    public TreeElement getElementByClassIndex(int classIndex) {
        ClassIndexVisitor civ = new ClassIndexVisitor(classIndex);
        this.classTree.visit(civ);
        return civ.getFound();
    }

    @Override
    public Object getRoot() {
        return this.classTree.getRoot();
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeElement pte = (TreeElement)parent;
        TreeElement te = pte.getChild(index);
        return te;
    }

    @Override
    public int getChildCount(Object parent) {
        TreeElement te = (TreeElement)parent;
        return te.getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        TreeElement te = (TreeElement)node;
        return te.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeElement te1 = (TreeElement)parent;
        TreeElement te2 = (TreeElement)child;
        return te1.getIndexOfChild(te2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }
}

