/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.abc.avm2.flowgraph.Graph;
import com.jpexs.asdec.abc.avm2.flowgraph.GraphPart;
import com.jpexs.asdec.gui.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GraphFrame
extends JFrame {
    public GraphFrame(Graph graph, String name) {
        this.setSize(500, 500);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        cnt.add(new JScrollPane(new GraphPanel(graph)));
        this.setTitle("Graph " + name);
        View.setWindowIcon(this);
        View.centerScreen(this);
    }

    private class GraphPanel
    extends JPanel {
        private static final int SPACE_VERTICAL = 10;
        private static final int SPACE_HORIZONTAL = 10;
        private static final int BLOCK_WIDTH = 100;
        private static final int BLOCK_HEIGHT = 20;
        private Graph graph;

        public GraphPanel(Graph graph) {
            this.graph = graph;
            this.setPreferredSize(new Dimension(110 * this.getPartWidth(graph.head, new ArrayList<GraphPart>()), 30 * this.getPartHeight(graph.head, new ArrayList<GraphPart>())));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.black);
            this.paintPart(g, this.graph.head, 0, this.getPartWidth(this.graph.head, new ArrayList<GraphPart>()) * 110 / 2, new ArrayList<GraphPart>());
        }

        private void paintPart(Graphics g, GraphPart part, int y, int x, List<GraphPart> used) {
            ArrayList<GraphPart> l = new ArrayList<GraphPart>();
            l.addAll(used);
            int totalWidthParts = this.getPartWidth(part, l);
            int totalWidth = totalWidthParts * 110;
            g.drawRect(x - 50 - 5, y, 100, 20);
            g.drawString(part.toString(), x - 50, y + 20);
            if (used.contains(part)) {
                return;
            }
            used.add(part);
            if (part.nextParts.size() > 0) {
                int cx = x - totalWidth / 2;
                for (int p = 0; p < part.nextParts.size(); ++p) {
                    l = new ArrayList();
                    l.addAll(used);
                    int cellWidth = this.getPartWidth(part.nextParts.get(p), l) * 110;
                    g.setColor(Color.black);
                    g.drawLine(x, y + 20, cx + cellWidth / 2, y + 20 + 10);
                    this.paintPart(g, part.nextParts.get(p), y + 20 + 10, cx + cellWidth / 2, used);
                    cx += cellWidth;
                }
            }
        }

        private int getPartHeight(GraphPart part, List<GraphPart> used) {
            if (used.contains(part)) {
                return 1;
            }
            used.add(part);
            int maxH = 0;
            for (int p = 0; p < part.nextParts.size(); ++p) {
                int h = this.getPartHeight(part.nextParts.get(p), used);
                if (h <= maxH) continue;
                maxH = h;
            }
            return 1 + maxH;
        }

        private int getPartWidth(GraphPart part, List<GraphPart> used) {
            if (used.contains(part)) {
                return 1;
            }
            used.add(part);
            if (part.nextParts.isEmpty()) {
                return 1;
            }
            int w = 0;
            for (GraphPart subpart : part.nextParts) {
                w += this.getPartWidth(subpart, used);
            }
            return w;
        }
    }
}

