/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.gui.LineMarkedEditorPane;
import com.jpexs.asdec.abc.methodinfo_parser.MethodInfoParser;
import com.jpexs.asdec.abc.methodinfo_parser.ParseException;
import com.jpexs.asdec.abc.types.MethodInfo;
import com.jpexs.asdec.helpers.Helper;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsyntaxpane.syntaxkits.Flasm3MethodInfoSyntaxKit;

public class MethodInfoPanel
extends JPanel {
    public LineMarkedEditorPane paramEditor;
    public JEditorPane returnTypeEditor = new JEditorPane();
    private MethodInfo methodInfo;
    private ABC abc;

    public MethodInfoPanel() {
        this.paramEditor = new LineMarkedEditorPane();
        this.setLayout(new BoxLayout(this, 3));
        this.add(new JLabel("Parameters:"));
        this.add(new JScrollPane(this.paramEditor));
        this.add(new JLabel("Return value type:"));
        JScrollPane jsp = new JScrollPane(this.returnTypeEditor);
        this.add(jsp);
        this.paramEditor.setContentType("text/flasm3_methodinfo");
        this.returnTypeEditor.setContentType("text/flasm3_methodinfo");
        jsp.setMaximumSize(new Dimension(1024, 25));
        Flasm3MethodInfoSyntaxKit sk = (Flasm3MethodInfoSyntaxKit)this.returnTypeEditor.getEditorKit();
        sk.deinstallComponent(this.returnTypeEditor, "jsyntaxpane.components.LineNumbersRuler");
    }

    public void load(int methodInfoIndex, ABC abc) {
        this.abc = abc;
        if (methodInfoIndex <= 0) {
            this.paramEditor.setText("");
        }
        this.methodInfo = abc.method_info[methodInfoIndex];
        int p = 0;
        String ret = "";
        int optParPos = 0;
        if (this.methodInfo.flagHas_optional()) {
            optParPos = this.methodInfo.param_types.length - this.methodInfo.optional.length;
        }
        for (int ptype : this.methodInfo.param_types) {
            if (p > 0) {
                ret = ret + ",\n";
            }
            if (this.methodInfo.flagHas_paramnames()) {
                // empty if block
            }
            ret = ret + "param" + (p + 1);
            ret = ret + ":";
            ret = ptype == 0 ? ret + "*" : ret + "m[" + ptype + "]\"" + Helper.escapeString(abc.constants.constant_multiname[ptype].toString(abc.constants, new ArrayList<String>())) + "\"";
            if (this.methodInfo.flagHas_optional() && p >= optParPos) {
                ret = ret + "=" + this.methodInfo.optional[p - optParPos].toString(abc.constants);
            }
            ++p;
        }
        if (this.methodInfo.flagNeed_rest()) {
            ret = ret + ",\n... rest";
        }
        this.paramEditor.setText(ret);
        if (this.methodInfo.ret_type == 0) {
            this.returnTypeEditor.setText("*");
        } else {
            this.returnTypeEditor.setText("m[" + this.methodInfo.ret_type + "]\"" + Helper.escapeString(abc.constants.constant_multiname[this.methodInfo.ret_type].toString(abc.constants, new ArrayList<String>())) + "\"");
        }
    }

    public boolean save() {
        try {
            MethodInfoParser.parseParams(this.paramEditor.getText(), this.methodInfo, this.abc);
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this.paramEditor, ex.text, "MethodInfo Params Error", 0);
            return false;
        }
        try {
            MethodInfoParser.parseReturnType(this.returnTypeEditor.getText(), this.methodInfo);
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this.returnTypeEditor, ex.text, "MethodInfo Return type Error", 0);
            return false;
        }
        return true;
    }
}

