/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.gui.UsageListModel;
import com.jpexs.asdec.abc.usages.InsideClassMultinameUsage;
import com.jpexs.asdec.abc.usages.MethodMultinameUsage;
import com.jpexs.asdec.abc.usages.MultinameUsage;
import com.jpexs.asdec.abc.usages.TraitMultinameUsage;
import com.jpexs.asdec.gui.View;
import com.jpexs.asdec.tags.DoABCTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class UsageFrame
extends JFrame
implements ActionListener,
MouseListener {
    private JButton gotoButton = new JButton("Go to");
    private JButton cancelButton = new JButton("Cancel");
    private JList usageList;
    private UsageListModel usageListModel;
    private ABC abc;

    public UsageFrame(List<DoABCTag> abcTags, ABC abc, int multinameIndex) {
        List<MultinameUsage> usages = abc.findMultinameUsage(multinameIndex);
        this.abc = abc;
        this.usageListModel = new UsageListModel(abcTags, abc);
        for (MultinameUsage u : usages) {
            this.usageListModel.addElement(u);
        }
        this.usageList = new JList(this.usageListModel);
        this.gotoButton.setActionCommand("GOTO");
        this.gotoButton.addActionListener(this);
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(this.gotoButton);
        buttonsPanel.add(this.cancelButton);
        this.usageList.addMouseListener(this);
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        cont.add((Component)new JScrollPane(this.usageList), "Center");
        cont.add((Component)buttonsPanel, "South");
        this.setSize(400, 300);
        this.setTitle("Usages:" + abc.constants.constant_multiname[multinameIndex].getNameWithNamespace(abc.constants));
        View.centerScreen(this);
        View.setWindowIcon(this);
    }

    private void gotoUsage() {
        MultinameUsage usage;
        if (this.usageList.getSelectedIndex() != -1 && (usage = this.usageListModel.getUsage(this.usageList.getSelectedIndex())) instanceof InsideClassMultinameUsage) {
            InsideClassMultinameUsage icu = (InsideClassMultinameUsage)usage;
            Main.mainFrame.abcPanel.classTree.selectClass(icu.classIndex);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (usage instanceof TraitMultinameUsage) {
                TraitMultinameUsage tmu = (TraitMultinameUsage)usage;
                int traitIndex = tmu.parentTraitIndex > -1 ? tmu.parentTraitIndex : tmu.traitIndex;
                if (!tmu.isStatic) {
                    traitIndex += this.abc.class_info[tmu.classIndex].static_traits.traits.length;
                }
                if (tmu instanceof MethodMultinameUsage) {
                    MethodMultinameUsage mmu = (MethodMultinameUsage)usage;
                    if (mmu.isInitializer) {
                        traitIndex = this.abc.class_info[mmu.classIndex].static_traits.traits.length + this.abc.instance_info[mmu.classIndex].instance_traits.traits.length + (mmu.isStatic ? 1 : 0);
                    }
                }
                Main.mainFrame.abcPanel.decompiledTextArea.gotoTrait(traitIndex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("GOTO")) {
            this.gotoUsage();
            this.setVisible(false);
        }
        if (e.getActionCommand().equals("CANCEL")) {
            this.setVisible(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.gotoUsage();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

