/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action;

import com.jpexs.asdec.EventListener;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.helpers.Highlighting;
import com.jpexs.asdec.tags.DefineButton2Tag;
import com.jpexs.asdec.tags.DefineButtonTag;
import com.jpexs.asdec.tags.DefineSpriteTag;
import com.jpexs.asdec.tags.DoInitActionTag;
import com.jpexs.asdec.tags.ExportAssetsTag;
import com.jpexs.asdec.tags.ShowFrameTag;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.tags.base.ASMSource;
import com.jpexs.asdec.tags.base.Container;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class TagNode {
    public List<TagNode> subItems;
    public Object tag;
    public boolean export = false;

    public TagNode(Object tag) {
        this.tag = tag;
        this.subItems = new ArrayList<TagNode>();
    }

    public String toString() {
        return this.tag.toString();
    }

    public static List<TagNode> createTagList(List<Object> list) {
        ArrayList<TagNode> ret = new ArrayList<TagNode>();
        int frame = 1;
        ArrayList<TagNode> frames = new ArrayList<TagNode>();
        ArrayList<ExportAssetsTag> exportAssetsTags = new ArrayList<ExportAssetsTag>();
        for (Object t : list) {
            TagNode tti;
            if (t instanceof ExportAssetsTag) {
                exportAssetsTags.add((ExportAssetsTag)t);
            }
            if (t instanceof ShowFrameTag) {
                tti = new TagNode("frame" + frame);
                for (int r = ret.size() - 1; r >= 0; --r) {
                    if (((TagNode)ret.get((int)r)).tag instanceof DefineSpriteTag || ((TagNode)ret.get((int)r)).tag instanceof DefineButtonTag || ((TagNode)ret.get((int)r)).tag instanceof DefineButton2Tag || ((TagNode)ret.get((int)r)).tag instanceof DoInitActionTag) continue;
                    tti.subItems.add((TagNode)ret.get(r));
                    ret.remove(r);
                }
                ++frame;
                frames.add(tti);
                continue;
            }
            if (t instanceof ASMSource) {
                tti = new TagNode(t);
                ret.add(tti);
                continue;
            }
            if (!(t instanceof Container) || ((Container)t).getItemCount() <= 0) continue;
            tti = new TagNode(t);
            List<Object> subItems = ((Container)t).getSubItems();
            tti.subItems = TagNode.createTagList(subItems);
            ret.add(tti);
        }
        ret.addAll(frames);
        for (int i = ret.size() - 1; i >= 0; --i) {
            ASMSource ass;
            if (((TagNode)ret.get((int)i)).tag instanceof DefineSpriteTag) {
                ((DefineSpriteTag)((TagNode)ret.get((int)i)).tag).exportAssetsTags = exportAssetsTags;
            }
            if (((TagNode)ret.get((int)i)).tag instanceof DefineButtonTag) {
                ((DefineButtonTag)((TagNode)ret.get((int)i)).tag).exportAssetsTags = exportAssetsTags;
            }
            if (((TagNode)ret.get((int)i)).tag instanceof DefineButton2Tag) {
                ((DefineButton2Tag)((TagNode)ret.get((int)i)).tag).exportAssetsTags = exportAssetsTags;
            }
            if (((TagNode)ret.get((int)i)).tag instanceof DoInitActionTag) {
                ((DoInitActionTag)((TagNode)ret.get((int)i)).tag).exportAssetsTags = exportAssetsTags;
            }
            if (((TagNode)ret.get((int)i)).tag instanceof ASMSource && (ass = (ASMSource)((TagNode)ret.get((int)i)).tag).containsSource() || !((TagNode)ret.get((int)i)).subItems.isEmpty()) continue;
            ret.remove(i);
        }
        return ret;
    }

    public static void setExport(List<TagNode> nodeList, boolean export) {
        for (TagNode node : nodeList) {
            node.export = export;
            TagNode.setExport(node.subItems, export);
        }
    }

    public static boolean exportNode(List<TagNode> nodeList, String outdir, boolean isPcode) {
        return TagNode.exportNode(nodeList, outdir, isPcode, null);
    }

    public static boolean exportNode(List<TagNode> nodeList, String outdir, boolean isPcode, EventListener ev) {
        File dir = new File(outdir);
        ArrayList<String> existingNames = new ArrayList<String>();
        for (TagNode node : nodeList) {
            String name = "";
            name = node.tag instanceof Tag ? ((Tag)node.tag).getExportName() : node.tag.toString();
            int i = 1;
            String baseName = name;
            while (existingNames.contains(name)) {
                name = baseName + "_" + ++i;
            }
            existingNames.add(name);
            if (node.subItems.isEmpty()) {
                if (!(node.tag instanceof ASMSource) || !node.export) continue;
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                try {
                    String ret;
                    String f = outdir + File.separatorChar + name + ".as";
                    if (ev != null) {
                        ev.handleEvent("export", "Exporting " + f + " ...");
                    }
                    if (isPcode) {
                        ret = ((ASMSource)node.tag).getASMSource(10);
                    } else {
                        List<Action> as = ((ASMSource)node.tag).getActions(10);
                        Action.setActionsAddresses(as, 0L, 10);
                        ret = Highlighting.stripHilights(Action.actionsToSource(as, 10));
                    }
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(ret.getBytes());
                    fos.close();
                }
                catch (Exception ex) {}
                continue;
            }
            TagNode.exportNode(node.subItems, outdir + File.separatorChar + name, isPcode, ev);
        }
        return true;
    }
}

