/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.swf5;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.parser.FlasmLexer;
import com.jpexs.asdec.action.parser.ParseException;
import com.jpexs.asdec.action.parser.ParsedSymbol;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.TreeItem;
import com.jpexs.asdec.helpers.Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class ActionConstantPool
extends Action {
    public List<String> constantPool = new ArrayList<String>();

    public ActionConstantPool(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(136, actionLength);
        sis = new SWFInputStream(new ByteArrayInputStream(sis.readBytes(actionLength)), version);
        int count = sis.readUI16();
        for (int i = 0; i < count; ++i) {
            this.constantPool.add(sis.readString());
        }
    }

    public ActionConstantPool(FlasmLexer lexer) throws IOException, ParseException {
        super(136, 0);
        while (true) {
            ParsedSymbol symb = lexer.yylex();
            if (symb.type != 1) break;
            this.constantPool.add((String)symb.value);
        }
        lexer.yypushback(lexer.yylength());
    }

    @Override
    public byte[] getBytes(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version);
        try {
            sos.writeUI16(this.constantPool.size());
            for (String s : this.constantPool) {
                sos.writeString(s);
            }
            sos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.surroundWithAction(baos.toByteArray(), version);
    }

    @Override
    public String toString() {
        String ret = "";
        for (int i = 0; i < this.constantPool.size(); ++i) {
            if (i > 0) {
                ret = ret + " ";
            }
            ret = ret + "\"" + Helper.escapeString(this.constantPool.get(i)) + "\"";
        }
        return "ConstantPool " + ret;
    }

    @Override
    public void translate(Stack<TreeItem> stack, ConstantPool constants, List<TreeItem> output, HashMap<Integer, String> regNames) {
        constants.constants = this.constantPool;
    }
}

