/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.swf5;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.parser.ASMParser;
import com.jpexs.asdec.action.parser.FlasmLexer;
import com.jpexs.asdec.action.parser.Label;
import com.jpexs.asdec.action.parser.ParseException;
import com.jpexs.asdec.helpers.Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ActionDefineFunction
extends Action {
    public String functionName;
    public List<String> paramNames = new ArrayList<String>();
    public List<Action> code;
    public int codeSize;

    public ActionDefineFunction(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(155, actionLength);
        this.functionName = sis.readString();
        int numParams = sis.readUI16();
        for (int i = 0; i < numParams; ++i) {
            this.paramNames.add(sis.readString());
        }
        this.codeSize = sis.readUI16();
        this.code = new SWFInputStream(new ByteArrayInputStream(sis.readBytes(this.codeSize)), version).readActionList();
    }

    public ActionDefineFunction(List<Label> labels, long address, FlasmLexer lexer, List<String> constantPool, int version) throws IOException, ParseException {
        super(155, 0);
        this.functionName = this.lexString(lexer);
        int numParams = (int)this.lexLong(lexer);
        for (int i = 0; i < numParams; ++i) {
            this.paramNames.add(this.lexString(lexer));
        }
        this.lexBlockOpen(lexer);
        this.code = ASMParser.parse(labels, address + this.getPreLen(version), lexer, constantPool, version);
    }

    @Override
    public byte[] getBytes(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try {
            sos.writeString(this.functionName);
            sos.writeUI16(this.paramNames.size());
            for (String s : this.paramNames) {
                sos.writeString(s);
            }
            byte[] codeBytes = Action.actionsToBytes(this.code, false, version);
            sos.writeUI16(codeBytes.length);
            sos.close();
            baos2.write(this.surroundWithAction(baos.toByteArray(), version));
            baos2.write(codeBytes);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos2.toByteArray();
    }

    private long getPreLen(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version);
        try {
            sos.writeString(this.functionName);
            sos.writeUI16(this.paramNames.size());
            for (String s : this.paramNames) {
                sos.writeString(s);
            }
            sos.writeUI16(0);
            sos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.surroundWithAction(baos.toByteArray(), version).length;
    }

    @Override
    public void setAddress(long address, int version) {
        super.setAddress(address, version);
        Action.setActionsAddresses(this.code, address + this.getPreLen(version), version);
    }

    @Override
    public String getASMSource(List<Long> knownAddreses, List<String> constantPool, int version) {
        String paramStr = "";
        for (int i = 0; i < this.paramNames.size(); ++i) {
            paramStr = paramStr + "\"" + Helper.escapeString(this.paramNames.get(i)) + "\"";
            paramStr = paramStr + " ";
        }
        return "DefineFunction \"" + Helper.escapeString(this.functionName) + "\" " + this.paramNames.size() + " " + paramStr + " {\r\n" + Action.actionsToString(this.code, knownAddreses, constantPool, version) + "}";
    }

    @Override
    public List<Long> getAllRefs(int version) {
        return Action.getActionsAllRefs(this.code, version);
    }

    @Override
    public List<Action> getAllIfsOrJumps() {
        return Action.getActionsAllIfsOrJumps(this.code);
    }
}

