/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.swf7;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.parser.ASMParser;
import com.jpexs.asdec.action.parser.FlasmLexer;
import com.jpexs.asdec.action.parser.Label;
import com.jpexs.asdec.action.parser.ParseException;
import com.jpexs.asdec.action.parser.ParsedSymbol;
import com.jpexs.asdec.action.swf4.RegisterNumber;
import com.jpexs.asdec.helpers.Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ActionTry
extends Action {
    public boolean catchInRegisterFlag;
    public boolean finallyBlockFlag;
    public boolean catchBlockFlag;
    public String catchName;
    public int catchRegister;
    public List<Action> tryBody;
    public List<Action> catchBody;
    public List<Action> finallyBody;

    public ActionTry(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(143, actionLength);
        sis.readUB(5);
        this.catchInRegisterFlag = sis.readUB(1) == 1L;
        this.finallyBlockFlag = sis.readUB(1) == 1L;
        this.catchBlockFlag = sis.readUB(1) == 1L;
        int trySize = sis.readUI16();
        int catchSize = sis.readUI16();
        int finallySize = sis.readUI16();
        if (this.catchInRegisterFlag) {
            this.catchRegister = sis.readUI8();
        } else {
            this.catchName = sis.readString();
        }
        byte[] tryBodyBytes = sis.readBytes(trySize);
        byte[] catchBodyBytes = sis.readBytes(catchSize);
        byte[] finallyBodyBytes = sis.readBytes(finallySize);
        this.tryBody = new SWFInputStream(new ByteArrayInputStream(tryBodyBytes), version).readActionList();
        this.catchBody = new SWFInputStream(new ByteArrayInputStream(catchBodyBytes), version).readActionList();
        this.finallyBody = new SWFInputStream(new ByteArrayInputStream(finallyBodyBytes), version).readActionList();
    }

    @Override
    public void setAddress(long address, int version) {
        super.setAddress(address, version);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version);
        try {
            sos.writeUB(5, 0L);
            sos.writeUB(1, this.catchInRegisterFlag ? 1L : 0L);
            sos.writeUB(1, this.finallyBlockFlag ? 1L : 0L);
            sos.writeUB(1, this.catchBlockFlag ? 1L : 0L);
            byte[] tryBodyBytes = Action.actionsToBytes(this.tryBody, false, version);
            byte[] catchBodyBytes = Action.actionsToBytes(this.catchBody, false, version);
            byte[] finallyBodyBytes = Action.actionsToBytes(this.finallyBody, false, version);
            sos.writeUI16(tryBodyBytes.length);
            sos.writeUI16(catchBodyBytes.length);
            sos.writeUI16(finallyBodyBytes.length);
            if (this.catchInRegisterFlag) {
                sos.writeUI8(this.catchRegister);
            } else {
                sos.writeString(this.catchName);
            }
            Action.setActionsAddresses(this.tryBody, address + (long)baos.toByteArray().length, version);
            sos.write(tryBodyBytes);
            Action.setActionsAddresses(this.catchBody, address + (long)baos.toByteArray().length, version);
            sos.write(catchBodyBytes);
            Action.setActionsAddresses(this.finallyBody, address + (long)baos.toByteArray().length, version);
            sos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public byte[] getBytes(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version);
        try {
            sos.writeUB(5, 0L);
            sos.writeUB(1, this.catchInRegisterFlag ? 1L : 0L);
            sos.writeUB(1, this.finallyBlockFlag ? 1L : 0L);
            sos.writeUB(1, this.catchBlockFlag ? 1L : 0L);
            byte[] tryBodyBytes = Action.actionsToBytes(this.tryBody, false, version);
            byte[] catchBodyBytes = Action.actionsToBytes(this.catchBody, false, version);
            byte[] finallyBodyBytes = Action.actionsToBytes(this.finallyBody, false, version);
            sos.writeUI16(tryBodyBytes.length);
            sos.writeUI16(catchBodyBytes.length);
            sos.writeUI16(finallyBodyBytes.length);
            if (this.catchInRegisterFlag) {
                sos.writeUI8(this.catchRegister);
            } else {
                sos.writeString(this.catchName);
            }
            sos.write(tryBodyBytes);
            sos.write(catchBodyBytes);
            sos.write(finallyBodyBytes);
            sos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.surroundWithAction(baos.toByteArray(), version);
    }

    public ActionTry(List<Label> labels, long address, FlasmLexer lexer, List<String> constantPool, int version) throws IOException, ParseException {
        super(143, 0);
        this.lexBlockOpen(lexer);
        this.tryBody = ASMParser.parse(labels, address + 4L + 6L, lexer, constantPool, version);
        ParsedSymbol symb = lexer.yylex();
        this.catchBlockFlag = false;
        if (symb.type == 3) {
            if (((String)symb.value).toLowerCase().equals("catch")) {
                this.catchBlockFlag = true;
                ParsedSymbol catchedVal = lexer.yylex();
                if (catchedVal.type == 12) {
                    this.catchInRegisterFlag = true;
                    this.catchRegister = ((RegisterNumber)catchedVal.value).number;
                } else if (catchedVal.type == 1) {
                    this.catchInRegisterFlag = false;
                    this.catchName = (String)catchedVal.value;
                } else {
                    throw new ParseException("Catched name or register expected", lexer.yyline());
                }
                this.lexBlockOpen(lexer);
                this.catchBody = ASMParser.parse(labels, address + 4L + 6L + (long)Action.actionsToBytes(this.tryBody, false, version).length, lexer, constantPool, version);
                symb = lexer.yylex();
            }
            if (symb.type == 3) {
                if (((String)symb.value).toLowerCase().equals("finally")) {
                    this.finallyBlockFlag = true;
                    this.lexBlockOpen(lexer);
                    this.finallyBody = ASMParser.parse(labels, address + 4L + 6L + (long)Action.actionsToBytes(this.tryBody, false, version).length + (long)Action.actionsToBytes(this.catchBody, false, version).length, lexer, constantPool, version);
                } else {
                    this.finallyBlockFlag = false;
                    lexer.yypushback(lexer.yylength());
                }
            } else {
                this.finallyBlockFlag = false;
                lexer.yypushback(lexer.yylength());
            }
        } else {
            lexer.yypushback(lexer.yylength());
        }
    }

    @Override
    public String getASMSource(List<Long> knownAddreses, List<String> constantPool, int version) {
        String ret = "";
        ret = ret + "Try {";
        ret = ret + Action.actionsToString(this.tryBody, knownAddreses, constantPool, version);
        ret = ret + "}";
        if (this.catchBlockFlag) {
            ret = ret + "\r\nCatch ";
            ret = this.catchInRegisterFlag ? ret + "register" + this.catchRegister : ret + "\"" + Helper.escapeString(this.catchName) + "\"";
            ret = ret + " {\r\n";
            ret = ret + Action.actionsToString(this.catchBody, knownAddreses, constantPool, version);
            ret = ret + "}";
        }
        if (this.finallyBlockFlag) {
            ret = ret + "\r\nFinally {\r\n";
            ret = ret + Action.actionsToString(this.finallyBody, knownAddreses, constantPool, version);
            ret = ret + "}";
        }
        return ret;
    }

    @Override
    public List<Long> getAllRefs(int version) {
        ArrayList<Long> ret = new ArrayList<Long>();
        ret.addAll(Action.getActionsAllRefs(this.tryBody, version));
        ret.addAll(Action.getActionsAllRefs(this.catchBody, version));
        ret.addAll(Action.getActionsAllRefs(this.finallyBody, version));
        return ret;
    }

    @Override
    public List<Action> getAllIfsOrJumps() {
        ArrayList<Action> ret = new ArrayList<Action>();
        ret.addAll(Action.getActionsAllIfsOrJumps(this.tryBody));
        ret.addAll(Action.getActionsAllIfsOrJumps(this.catchBody));
        ret.addAll(Action.getActionsAllIfsOrJumps(this.finallyBody));
        return ret;
    }
}

