/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.treemodel;

import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.swf4.Undefined;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.DirectValueTreeItem;
import com.jpexs.asdec.action.treemodel.TreeItem;
import java.util.List;

public class NewMethodTreeItem
extends TreeItem {
    public TreeItem methodName;
    public TreeItem scriptObject;
    public List<TreeItem> arguments;

    public NewMethodTreeItem(Action instruction, TreeItem scriptObject, TreeItem methodName, List<TreeItem> arguments) {
        super(instruction, 0);
        this.methodName = methodName;
        this.arguments = arguments;
        this.scriptObject = scriptObject;
    }

    @Override
    public String toString(ConstantPool constants) {
        String paramStr = "";
        for (int t = 0; t < this.arguments.size(); ++t) {
            if (t > 0) {
                paramStr = paramStr + ",";
            }
            paramStr = paramStr + this.arguments.get(t).toString(constants);
        }
        boolean blankMethod = false;
        String methodNameStr = "";
        if (this.methodName instanceof DirectValueTreeItem) {
            if (((DirectValueTreeItem)this.methodName).value instanceof Undefined) {
                blankMethod = true;
            } else if (((DirectValueTreeItem)this.methodName).value instanceof String) {
                if (((DirectValueTreeItem)this.methodName).value.equals("")) {
                    blankMethod = true;
                }
                methodNameStr = ((DirectValueTreeItem)this.methodName).toStringNoQuotes(constants);
            } else {
                methodNameStr = this.methodName.toString(constants);
            }
        } else {
            methodNameStr = this.methodName.toString(constants);
        }
        if (blankMethod) {
            return this.scriptObject.toString(constants) + "(" + paramStr + ")";
        }
        return "new " + this.scriptObject.toString(constants) + "." + methodNameStr + "(" + paramStr + ")";
    }
}

