/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.treemodel.clauses;

import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.ContinueTreeItem;
import com.jpexs.asdec.action.treemodel.TreeItem;
import com.jpexs.asdec.action.treemodel.clauses.Block;
import com.jpexs.asdec.action.treemodel.clauses.LoopTreeItem;
import java.util.ArrayList;
import java.util.List;

public class ForTreeItem
extends LoopTreeItem
implements Block {
    public List<TreeItem> firstCommands;
    public TreeItem expression;
    public List<TreeItem> finalCommands;
    public List<TreeItem> commands;

    public ForTreeItem(Action instruction, long loopBreak, long loopContinue, List<TreeItem> firstCommands, TreeItem expression, List<TreeItem> finalCommands, List<TreeItem> commands) {
        super(instruction, loopBreak, loopContinue);
        this.firstCommands = firstCommands;
        this.expression = expression;
        this.finalCommands = finalCommands;
        this.commands = commands;
    }

    private String stripSemicolon(String s) {
        if (s.endsWith(";")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Override
    public String toString(ConstantPool constants) {
        int i;
        String ret = "";
        ret = ret + "loop" + this.loopBreak + ":\r\n";
        ret = ret + this.hilight("for(");
        for (i = 0; i < this.firstCommands.size(); ++i) {
            if (i > 0) {
                ret = ret + ",";
            }
            ret = ret + this.stripSemicolon(this.firstCommands.get(i).toString(constants));
        }
        ret = ret + ";";
        ret = ret + this.expression.toString(constants);
        ret = ret + ";";
        for (i = 0; i < this.finalCommands.size(); ++i) {
            if (i > 0) {
                ret = ret + ",";
            }
            ret = ret + this.stripSemicolon(this.finalCommands.get(i).toString(constants));
        }
        ret = ret + this.hilight(")") + "\r\n{\r\n";
        for (TreeItem ti : this.commands) {
            ret = ret + ti.toString(constants) + "\r\n";
        }
        ret = ret + this.hilight("}") + "\r\n";
        ret = ret + ":loop" + this.loopBreak;
        return ret;
    }

    @Override
    public List<ContinueTreeItem> getContinues() {
        ArrayList<ContinueTreeItem> ret = new ArrayList<ContinueTreeItem>();
        for (TreeItem ti : this.commands) {
            if (ti instanceof ContinueTreeItem) {
                ret.add((ContinueTreeItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        return ret;
    }
}

