/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.treemodel.clauses;

import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.ContinueTreeItem;
import com.jpexs.asdec.action.treemodel.TreeItem;
import com.jpexs.asdec.action.treemodel.clauses.Block;
import java.util.ArrayList;
import java.util.List;

public class TryTreeItem
extends TreeItem
implements Block {
    public List<TreeItem> tryCommands;
    public List<TreeItem> catchExceptions;
    public List<List<TreeItem>> catchCommands;
    public List<TreeItem> finallyCommands;

    public TryTreeItem(List<TreeItem> tryCommands, List<TreeItem> catchExceptions, List<List<TreeItem>> catchCommands, List<TreeItem> finallyCommands) {
        super(null, 16);
        this.tryCommands = tryCommands;
        this.catchExceptions = catchExceptions;
        this.catchCommands = catchCommands;
        this.finallyCommands = finallyCommands;
    }

    @Override
    public String toString(ConstantPool constants) {
        String ret = "";
        ret = ret + "try\r\n{\r\n";
        for (TreeItem ti : this.tryCommands) {
            ret = ret + ti.toString(constants) + "\r\n";
        }
        ret = ret + "}";
        for (int e = 0; e < this.catchExceptions.size(); ++e) {
            ret = ret + "\r\ncatch(" + this.catchExceptions.get(e).toString(constants) + ")\r\n{\r\n";
            List<TreeItem> commands = this.catchCommands.get(e);
            for (TreeItem ti : commands) {
                ret = ret + ti.toString(constants) + "\r\n";
            }
            ret = ret + "}";
        }
        if (this.finallyCommands.size() > 0) {
            ret = ret + "\r\nfinally\r\n{\r\n";
            for (TreeItem ti : this.finallyCommands) {
                ret = ret + ti.toString(constants) + "\r\n";
            }
            ret = ret + "}";
        }
        return ret;
    }

    @Override
    public List<ContinueTreeItem> getContinues() {
        ArrayList<ContinueTreeItem> ret = new ArrayList<ContinueTreeItem>();
        for (TreeItem treeItem : this.tryCommands) {
            if (treeItem instanceof ContinueTreeItem) {
                ret.add((ContinueTreeItem)treeItem);
            }
            if (!(treeItem instanceof Block)) continue;
            ret.addAll(((Block)((Object)treeItem)).getContinues());
        }
        if (this.finallyCommands != null) {
            for (TreeItem treeItem : this.finallyCommands) {
                if (treeItem instanceof ContinueTreeItem) {
                    ret.add((ContinueTreeItem)treeItem);
                }
                if (!(treeItem instanceof Block)) continue;
                ret.addAll(((Block)((Object)treeItem)).getContinues());
            }
        }
        for (List list : this.catchCommands) {
            for (TreeItem ti : list) {
                if (ti instanceof ContinueTreeItem) {
                    ret.add((ContinueTreeItem)ti);
                }
                if (!(ti instanceof Block)) continue;
                ret.addAll(((Block)((Object)ti)).getContinues());
            }
        }
        return ret;
    }
}

