/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.gui.proxy;

import com.jpexs.asdec.Configuration;
import com.jpexs.asdec.Main;
import com.jpexs.asdec.gui.View;
import com.jpexs.asdec.gui.proxy.SWFListModel;
import com.jpexs.proxy.CatchedListener;
import com.jpexs.proxy.ReplacedListener;
import com.jpexs.proxy.Replacement;
import com.jpexs.proxy.Server;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ProxyFrame
extends JFrame
implements ActionListener,
CatchedListener,
MouseListener,
ReplacedListener {
    private JList swfList;
    private SWFListModel listModel;
    private JButton switchButton = new JButton("Start proxy");
    private boolean started = false;
    private JTextField portField = new JTextField("55555");
    private JCheckBox sniffSWFCheckBox = new JCheckBox("SWF", false);
    private JCheckBox sniffOSCheckBox = new JCheckBox("OctetStream", false);
    private JCheckBox sniffJSCheckBox = new JCheckBox("JS", false);
    private JCheckBox sniffXMLCheckBox = new JCheckBox("XML", false);

    public boolean isRunning() {
        return this.started;
    }

    public void setPort(int port) {
        this.portField.setText("" + port);
    }

    public ProxyFrame() {
        this.listModel = new SWFListModel(Configuration.getReplacements());
        this.swfList = new JList(this.listModel);
        this.swfList.addMouseListener(this);
        this.swfList.setFont(new Font("Monospaced", 0, 12));
        this.switchButton.addActionListener(this);
        this.switchButton.setActionCommand("SWITCHSTATE");
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)new JScrollPane(this.swfList), "Center");
        this.portField.setPreferredSize(new Dimension(60, 22));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(new Label("Port:"));
        buttonsPanel.add(this.portField);
        buttonsPanel.add(this.switchButton);
        cnt.add((Component)buttonsPanel, "North");
        JPanel buttonsPanel23 = new JPanel();
        buttonsPanel23.setLayout(new BoxLayout(buttonsPanel23, 1));
        JPanel buttonsPanel2 = new JPanel();
        buttonsPanel2.setLayout(new FlowLayout());
        JButton openButton = new JButton("Open");
        openButton.setActionCommand("OPEN");
        openButton.addActionListener(this);
        buttonsPanel2.add(openButton);
        JButton clearButton = new JButton("Clear");
        clearButton.setActionCommand("CLEAR");
        clearButton.addActionListener(this);
        buttonsPanel2.add(clearButton);
        JButton renameButton = new JButton("Rename");
        renameButton.setActionCommand("RENAME");
        renameButton.addActionListener(this);
        buttonsPanel2.add(renameButton);
        JButton removeButton = new JButton("Remove");
        removeButton.setActionCommand("REMOVE");
        removeButton.addActionListener(this);
        buttonsPanel2.add(removeButton);
        JPanel buttonsPanel3 = new JPanel();
        buttonsPanel3.setLayout(new FlowLayout());
        buttonsPanel3.add(new JLabel("Sniff:"));
        buttonsPanel3.add(this.sniffSWFCheckBox);
        buttonsPanel3.add(this.sniffOSCheckBox);
        buttonsPanel23.add(buttonsPanel2);
        buttonsPanel23.add(buttonsPanel3);
        cnt.add((Component)buttonsPanel23, "South");
        this.setSize(400, 300);
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.setTitle("Proxy");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProxyFrame.this.setVisible(false);
                Main.removeTrayIcon();
                if (Main.mainFrame != null && Main.mainFrame.isVisible()) {
                    return;
                }
                Main.showModeFrame();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                ProxyFrame.this.setVisible(false);
            }
        });
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(View.loadImage("com/jpexs/asdec/gui/graphics/proxy16.png"));
        images.add(View.loadImage("com/jpexs/asdec/gui/graphics/proxy24.png"));
        images.add(View.loadImage("com/jpexs/asdec/gui/graphics/proxy32.png"));
        images.add(View.loadImage("com/jpexs/asdec/gui/graphics/proxy48.png"));
        this.setIconImages(images);
    }

    private void open() {
        if (this.swfList.getSelectedIndex() > -1) {
            Replacement r = (Replacement)this.listModel.getElementAt(this.swfList.getSelectedIndex());
            Main.maskURL = r.urlPattern;
            Main.openFile(r.targetFile);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OPEN")) {
            this.open();
        }
        if (e.getActionCommand().equals("RENAME") && this.swfList.getSelectedIndex() > -1) {
            String s;
            Replacement r = (Replacement)this.listModel.getElementAt(this.swfList.getSelectedIndex());
            r.urlPattern = s = JOptionPane.showInputDialog("URL", (Object)r.urlPattern);
            this.listModel.dataChanged(this.swfList.getSelectedIndex());
        }
        if (e.getActionCommand().equals("CLEAR")) {
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                Replacement r = (Replacement)this.listModel.getElementAt(i);
                File f = new File(Main.tempFile(r.targetFile));
                if (!f.exists()) continue;
                f.delete();
            }
            this.listModel.clear();
        }
        if (e.getActionCommand().equals("REMOVE")) {
            int lastIndex = -1;
            for (int k = this.listModel.getSize() - 1; k >= 0; --k) {
                if (!this.swfList.isSelectedIndex(k)) continue;
                Replacement r = this.listModel.removeURL(k);
                File f = new File(r.targetFile);
                if (f.exists()) {
                    f.delete();
                }
                lastIndex = k;
            }
            if (lastIndex >= this.listModel.getSize()) {
                --lastIndex;
            }
            if (lastIndex > -1) {
                this.swfList.setSelectedIndex(lastIndex);
            }
        }
        if (e.getActionCommand().equals("SWITCHSTATE")) {
            Main.switchProxy();
        }
    }

    public void switchState() {
        boolean bl = this.started = !this.started;
        if (this.started) {
            int port = 0;
            try {
                port = Integer.parseInt(this.portField.getText());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (port <= 0 || port > 65535) {
                JOptionPane.showMessageDialog(this, "Wrong format for port number.", "Error", 0);
                this.started = false;
                return;
            }
            ArrayList<String> catchedContentTypes = new ArrayList<String>();
            catchedContentTypes.add("application/x-shockwave-flash");
            catchedContentTypes.add("application/x-javascript");
            catchedContentTypes.add("application/javascript");
            catchedContentTypes.add("text/javascript");
            catchedContentTypes.add("application/json");
            catchedContentTypes.add("text/xml");
            catchedContentTypes.add("application/xml");
            catchedContentTypes.add("application/octet-stream");
            Server.startServer(port, Configuration.getReplacements(), catchedContentTypes, this, this);
            this.switchButton.setText("Stop proxy");
            this.portField.setEditable(false);
        } else {
            Server.stopServer();
            this.switchButton.setText("Start proxy");
            this.portField.setEditable(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.swfList && e.getClickCount() == 2) {
            this.open();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void catched(String contentType, String url, InputStream data) {
        boolean swfOnly = false;
        if (contentType.contains(";")) {
            contentType = contentType.substring(0, contentType.indexOf(";"));
        }
        if (!this.sniffSWFCheckBox.isSelected() && contentType.equals("application/x-shockwave-flash")) {
            return;
        }
        if (!this.sniffJSCheckBox.isSelected() && (contentType.equals("application/javascript") || contentType.equals("application/x-javascript") || contentType.equals("text/javascript") || contentType.equals("application/json"))) {
            return;
        }
        if (!this.sniffXMLCheckBox.isSelected() && (contentType.equals("application/xml") || contentType.equals("text/xml"))) {
            return;
        }
        if (!this.sniffOSCheckBox.isSelected() && contentType.equals("application/octet-stream")) {
            return;
        }
        if (!this.listModel.contains(url)) {
            try {
                int count;
                byte[] hdr = new byte[3];
                data.read(hdr);
                String shdr = new String(hdr);
                if (swfOnly && !shdr.equals("FWS") && !shdr.equals("CWS")) {
                    return;
                }
                File f = new File(Main.tempFile(url));
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(hdr);
                byte[] buf = new byte[2048];
                while ((count = data.read(buf)) > 0) {
                    fos.write(buf, 0, count);
                }
                fos.close();
                Replacement r = new Replacement(url, Main.tempFile(url));
                r.lastAccess = Calendar.getInstance();
                this.listModel.addURL(r);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Main.addTrayIcon();
        }
        super.setVisible(b);
    }

    @Override
    public void replaced(Replacement replacement, String url, String contentType) {
        this.listModel.dataChanged(this.listModel.indexOf(replacement));
    }
}

