/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.helpers;

import java.util.List;

public class Helper {
    private static final String SPACES12 = "            ";
    private static final String ZEROS8 = "00000000";

    public static String intArrToString(int[] array) {
        String s = "[";
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                s = s + ",";
            }
            s = s + array[i];
        }
        s = s + "]";
        return s;
    }

    public static String byteArrToString(byte[] array) {
        String s = "[";
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                s = s + " ";
            }
            s = s + Helper.padZeros(Integer.toHexString(array[i] & 0xFF), 2);
        }
        s = s + "]";
        return s;
    }

    public static String padZeros(String number, int length) {
        int count = length - number.length();
        for (int i = 0; i < count; ++i) {
            number = "0" + number;
        }
        return number;
    }

    public static String formatAddress(long number) {
        return Helper.padZeros(Long.toHexString(number), 4);
    }

    public static String padSpaceRight(String text, int width) {
        int oldLen;
        for (int i = oldLen = text.length(); i < width; ++i) {
            text = text + " ";
        }
        return text;
    }

    public static String escapeString(String s) {
        String ret = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            ret = c == '\n' ? ret + "\\n" : (c == '\r' ? ret + "\\r" : (c == '\t' ? ret + "\\t" : (c == '\b' ? ret + "\\b" : (c == '\t' ? ret + "\\t" : (c == '\f' ? ret + "\\f" : (c == '\\' ? ret + "\\\\" : (c == '\"' ? ret + "\\\"" : (c == '\'' ? ret + "\\'" : ret + c))))))));
        }
        return ret;
    }

    public static String formatHex(int value, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(value));
        if (width > sb.length()) {
            sb.insert(0, ZEROS8, 0, width - sb.length());
        }
        return sb.toString();
    }

    public static String formatInt(int value, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        if (width > sb.length()) {
            sb.insert(0, SPACES12, 0, width - sb.length());
        }
        return sb.toString();
    }

    public static String indent(int level, String ss) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < level * 2; ++ii) {
            sb.append(' ');
        }
        sb.append(ss);
        return sb.toString();
    }

    public static String bytesToHexString(byte[] bytes, int start) {
        StringBuilder sb = new StringBuilder();
        if (start < bytes.length) {
            for (int ii = start; ii < bytes.length; ++ii) {
                sb.append(Helper.formatHex(bytes[ii] & 0xFF, 2));
                sb.append(' ');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String bytesToHexString(int maxByteCountInString, byte[] bytes, int start) {
        if (bytes.length - start <= maxByteCountInString) {
            return Helper.bytesToHexString(bytes, start);
        }
        byte[] trailingBytes = new byte[maxByteCountInString / 2];
        byte[] headingBytes = new byte[maxByteCountInString - trailingBytes.length];
        System.arraycopy(bytes, start, headingBytes, 0, headingBytes.length);
        int startOfTrailingBytes = bytes.length - trailingBytes.length;
        System.arraycopy(bytes, startOfTrailingBytes, trailingBytes, 0, trailingBytes.length);
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.bytesToHexString(headingBytes, 0));
        if (trailingBytes.length > 0) {
            sb.append(" ... ");
            sb.append(Helper.bytesToHexString(trailingBytes, 0));
        }
        return sb.toString();
    }

    public static String format(String str, int len) {
        if (len <= str.length()) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        for (int ii = str.length(); ii < len; ++ii) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String joinStrings(List<String> arr, String glue) {
        String ret = "";
        boolean first = true;
        for (String s : arr) {
            if (!first) {
                ret = ret + glue;
            } else {
                first = false;
            }
            ret = ret + s;
        }
        return ret;
    }

    public static String joinStrings(String[] arr, String glue) {
        String ret = "";
        boolean first = true;
        for (String s : arr) {
            if (!first) {
                ret = ret + glue;
            } else {
                first = false;
            }
            ret = ret + s;
        }
        return ret;
    }
}

