/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CSMTextSettingsTag
extends Tag {
    public int textID;
    public int useFlashType;
    public int gridFit;
    public double thickness;
    public double sharpness;

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.textID);
            sos.writeUB(2, this.useFlashType);
            sos.writeUB(3, this.gridFit);
            sos.writeUB(3, 0L);
            sos.writeFIXED(this.thickness);
            sos.writeFIXED(this.sharpness);
            sos.writeUI8(0);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public CSMTextSettingsTag(byte[] data, int version, long pos) throws IOException {
        super(74, "CSMTextSettings", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.textID = sis.readUI16();
        this.useFlashType = (int)sis.readUB(2);
        this.gridFit = (int)sis.readUB(3);
        sis.readUB(3);
        this.thickness = sis.readFIXED();
        this.sharpness = sis.readFIXED();
        sis.readUI8();
    }

    @Override
    public String toString() {
        return "CSMTextSettings";
    }
}

