/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.abc.CopyOutputStream;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.tags.base.Container;
import com.jpexs.asdec.types.BUTTONCONDACTION;
import com.jpexs.asdec.types.BUTTONRECORD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefineButton2Tag
extends CharacterTag
implements Container {
    public int buttonId;
    public boolean trackAsMenu;
    public List<BUTTONRECORD> characters;
    public List<BUTTONCONDACTION> actions = new ArrayList<BUTTONCONDACTION>();

    @Override
    public int getCharacterID() {
        return this.buttonId;
    }

    public DefineButton2Tag(byte[] data, int version, long pos) throws IOException {
        super(34, "DefineButton2", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.buttonId = sis.readUI16();
        sis.readUB(7);
        this.trackAsMenu = sis.readUB(1) == 1L;
        int actionOffset = sis.readUI16();
        this.characters = sis.readBUTTONRECORDList(true);
        if (actionOffset > 0) {
            this.actions = sis.readBUTTONCONDACTIONList();
        }
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        if (Main.DISABLE_DANGEROUS) {
            return super.getData(version);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
        OutputStream os = baos = new ByteArrayOutputStream();
        if (Main.DEBUG_COPY) {
            os = new CopyOutputStream(os, bais);
        }
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            SWFInputStream sis;
            int len;
            ByteArrayOutputStream baos2;
            sos.writeUI16(this.buttonId);
            sos.writeUB(7, 0L);
            sos.writeUB(1, this.trackAsMenu ? 1L : 0L);
            OutputStream os2 = baos2 = new ByteArrayOutputStream();
            byte[] origbrdata = null;
            if (Main.DEBUG_COPY && (len = (sis = new SWFInputStream(bais, version)).readUI16()) != 0) {
                origbrdata = sis.readBytes(len - 2);
                os2 = new CopyOutputStream(os2, new ByteArrayInputStream(origbrdata));
            }
            SWFOutputStream sos2 = new SWFOutputStream(os2, version);
            sos2.writeBUTTONRECORDList(this.characters, true);
            sos2.close();
            byte[] brdata = baos2.toByteArray();
            if (!Main.DEBUG_COPY || origbrdata == null || origbrdata.length != brdata.length) {
                // empty if block
            }
            if (Main.DEBUG_COPY) {
                sos = new SWFOutputStream(baos, version);
            }
            if (this.actions == null || this.actions.isEmpty()) {
                sos.writeUI16(0);
            } else {
                sos.writeUI16(2 + brdata.length);
            }
            sos.write(brdata);
            if (Main.DEBUG_COPY) {
                sos = new SWFOutputStream(new CopyOutputStream(baos, bais), version);
            }
            sos.writeBUTTONCONDACTIONList(this.actions);
            sos.close();
        }
        catch (IOException e) {
            Logger.getLogger(DefineButton2Tag.class.getName()).log(Level.SEVERE, null, e);
        }
        return baos.toByteArray();
    }

    @Override
    public List<Object> getSubItems() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.addAll(this.actions);
        return ret;
    }

    @Override
    public int getItemCount() {
        return this.actions.size();
    }
}

