/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.abc.CopyOutputStream;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.tags.base.FontTag;
import com.jpexs.asdec.types.KERNINGRECORD;
import com.jpexs.asdec.types.LANGCODE;
import com.jpexs.asdec.types.RECT;
import com.jpexs.asdec.types.SHAPE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DefineFont2Tag
extends CharacterTag
implements FontTag {
    public int fontId;
    public boolean fontFlagsHasLayout;
    public boolean fontFlagsShiftJIS;
    public boolean fontFlagsSmallText;
    public boolean fontFlagsANSI;
    public boolean fontFlagsWideOffsets;
    public boolean fontFlagsWideCodes;
    public boolean fontFlagsItalic;
    public boolean fontFlagsBold;
    public LANGCODE languageCode;
    public String fontName;
    public int numGlyphs;
    public long[] offsetTable;
    public SHAPE[] glyphShapeTable;
    public int[] codeTable;
    public int fontAscent;
    public int fontDescent;
    public int fontLeading;
    public int[] fontAdvanceTable;
    public RECT[] fontBoundsTable;
    public KERNINGRECORD[] fontKerningTable;

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CopyOutputStream os = new CopyOutputStream(baos, new ByteArrayInputStream(this.data));
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            int i;
            sos.writeUI16(this.fontId);
            sos.writeUB(1, this.fontFlagsHasLayout ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsShiftJIS ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsSmallText ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsANSI ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsWideOffsets ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsWideCodes ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsItalic ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsBold ? 1L : 0L);
            sos.writeLANGCODE(this.languageCode);
            sos.writeUI8(this.fontName.getBytes().length);
            sos.write(this.fontName.getBytes());
            sos.writeUI16(this.numGlyphs);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            SWFOutputStream sos2 = new SWFOutputStream(baos2, version);
            for (int i2 = 0; i2 < this.numGlyphs; ++i2) {
                if (this.fontFlagsWideOffsets) {
                    sos2.writeUI32(this.offsetTable[i2]);
                    continue;
                }
                sos2.writeUI16((int)this.offsetTable[i2]);
            }
            byte[] ba2 = baos2.toByteArray();
            ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
            SWFOutputStream sos3 = new SWFOutputStream(baos3, version);
            for (int i3 = 0; i3 < this.numGlyphs; ++i3) {
                sos3.writeSHAPE(this.glyphShapeTable[i3], 1);
            }
            byte[] ba3 = baos3.toByteArray();
            sos.write(ba2);
            long offset = ba2.length + ba3.length;
            if (this.fontFlagsWideOffsets) {
                sos.writeUI32(offset + 4L);
            } else {
                sos.writeUI16((int)(offset + 2L));
            }
            sos.write(ba3);
            for (i = 0; i < this.numGlyphs; ++i) {
                if (this.fontFlagsWideCodes) {
                    sos.writeUI16(this.codeTable[i]);
                    continue;
                }
                sos.writeUI8(this.codeTable[i]);
            }
            if (this.fontFlagsHasLayout) {
                sos.writeSI16(this.fontAscent);
                sos.writeSI16(this.fontDescent);
                sos.writeSI16(this.fontLeading);
                for (i = 0; i < this.numGlyphs; ++i) {
                    sos.writeSI16(this.fontAdvanceTable[i]);
                }
                for (i = 0; i < this.numGlyphs; ++i) {
                    sos.writeRECT(this.fontBoundsTable[i]);
                }
                sos.writeUI16(this.fontKerningTable.length);
                for (int k = 0; k < this.fontKerningTable.length; ++k) {
                    sos.writeKERNINGRECORD(this.fontKerningTable[k], this.fontFlagsWideCodes);
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineFont2Tag(byte[] data, int version, long pos) throws IOException {
        super(48, "DefineFont2", data, pos);
        int i;
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.fontId = sis.readUI16();
        this.fontFlagsHasLayout = sis.readUB(1) == 1L;
        this.fontFlagsShiftJIS = sis.readUB(1) == 1L;
        this.fontFlagsSmallText = sis.readUB(1) == 1L;
        this.fontFlagsANSI = sis.readUB(1) == 1L;
        this.fontFlagsWideOffsets = sis.readUB(1) == 1L;
        this.fontFlagsWideCodes = sis.readUB(1) == 1L;
        this.fontFlagsItalic = sis.readUB(1) == 1L;
        this.fontFlagsBold = sis.readUB(1) == 1L;
        this.languageCode = sis.readLANGCODE();
        int fontNameLen = sis.readUI8();
        this.fontName = new String(sis.readBytes(fontNameLen));
        this.numGlyphs = sis.readUI16();
        this.offsetTable = new long[this.numGlyphs];
        for (int i2 = 0; i2 < this.numGlyphs; ++i2) {
            this.offsetTable[i2] = this.fontFlagsWideOffsets ? sis.readUI32() : (long)sis.readUI16();
        }
        long codeTableOffset = this.fontFlagsWideOffsets ? sis.readUI32() : (long)sis.readUI16();
        this.glyphShapeTable = new SHAPE[this.numGlyphs];
        for (i = 0; i < this.numGlyphs; ++i) {
            this.glyphShapeTable[i] = sis.readSHAPE(1);
        }
        this.codeTable = new int[this.numGlyphs];
        for (i = 0; i < this.numGlyphs; ++i) {
            this.codeTable[i] = this.fontFlagsWideCodes ? sis.readUI16() : sis.readUI8();
        }
        if (this.fontFlagsHasLayout) {
            this.fontAscent = sis.readSI16();
            this.fontDescent = sis.readSI16();
            this.fontLeading = sis.readSI16();
            this.fontAdvanceTable = new int[this.numGlyphs];
            for (i = 0; i < this.numGlyphs; ++i) {
                this.fontAdvanceTable[i] = sis.readSI16();
            }
            this.fontBoundsTable = new RECT[this.numGlyphs];
            for (i = 0; i < this.numGlyphs; ++i) {
                this.fontBoundsTable[i] = sis.readRECT();
            }
            int kerningCount = sis.readUI16();
            this.fontKerningTable = new KERNINGRECORD[kerningCount];
            for (int i3 = 0; i3 < kerningCount; ++i3) {
                this.fontKerningTable[i3] = sis.readKERNINGRECORD(this.fontFlagsWideCodes);
            }
        }
    }

    @Override
    public int getFontId() {
        return this.fontId;
    }

    @Override
    public SHAPE[] getGlyphShapeTable() {
        return this.glyphShapeTable;
    }

    @Override
    public int getCharacterID() {
        return this.fontId;
    }
}

