/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.base.AloneTag;
import com.jpexs.asdec.tags.base.BoundedTag;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.types.MORPHFILLSTYLEARRAY;
import com.jpexs.asdec.types.MORPHLINESTYLEARRAY;
import com.jpexs.asdec.types.RECT;
import com.jpexs.asdec.types.SHAPE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DefineMorphShape2Tag
extends CharacterTag
implements BoundedTag,
AloneTag {
    public int characterId;
    public RECT startBounds;
    public RECT endBounds;
    public RECT startEdgeBounds;
    public RECT endEdgeBounds;
    public boolean usesNonScalingStrokes;
    public boolean usesScalingStrokes;
    public MORPHFILLSTYLEARRAY morphFillStyles;
    public MORPHLINESTYLEARRAY morphLineStyles;
    public SHAPE startEdges;
    public SHAPE endEdges;

    @Override
    public RECT getRect() {
        RECT rect = new RECT();
        rect.Xmin = Math.min(this.startBounds.Xmin, this.endBounds.Xmin);
        rect.Ymin = Math.min(this.startBounds.Ymin, this.endBounds.Ymin);
        rect.Xmax = Math.max(this.startBounds.Xmax, this.endBounds.Xmax);
        rect.Ymax = Math.max(this.startBounds.Ymax, this.endBounds.Ymax);
        return rect;
    }

    @Override
    public int getCharacterID() {
        return this.characterId;
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.characterId);
            sos.writeRECT(this.startBounds);
            sos.writeRECT(this.endBounds);
            sos.writeRECT(this.startEdgeBounds);
            sos.writeRECT(this.endEdgeBounds);
            sos.writeUB(6, 0L);
            sos.writeUB(1, this.usesNonScalingStrokes ? 1L : 0L);
            sos.writeUB(1, this.usesScalingStrokes ? 1L : 0L);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            SWFOutputStream sos2 = new SWFOutputStream(baos2, version);
            sos2.writeMORPHFILLSTYLEARRAY(this.morphFillStyles, 2);
            sos2.writeMORPHLINESTYLEARRAY(this.morphLineStyles, 2);
            sos2.writeSHAPE(this.startEdges, 1);
            byte[] ba2 = baos2.toByteArray();
            sos.writeUI32(ba2.length);
            sos.write(ba2);
            sos.writeSHAPE(this.endEdges, 1);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineMorphShape2Tag(byte[] data, int version, long pos) throws IOException {
        super(84, "DefineMorphShape2", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.characterId = sis.readUI16();
        this.startBounds = sis.readRECT();
        this.endBounds = sis.readRECT();
        this.startEdgeBounds = sis.readRECT();
        this.endEdgeBounds = sis.readRECT();
        sis.readUB(6);
        this.usesNonScalingStrokes = sis.readUB(1) == 1L;
        this.usesScalingStrokes = sis.readUB(1) == 1L;
        long offset = sis.readUI32();
        this.morphFillStyles = sis.readMORPHFILLSTYLEARRAY();
        this.morphLineStyles = sis.readMORPHLINESTYLEARRAY(2);
        this.startEdges = sis.readSHAPE(1);
        this.endEdges = sis.readSHAPE(1);
    }
}

