/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.base.AloneTag;
import com.jpexs.asdec.tags.base.BoundedTag;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.types.MORPHFILLSTYLEARRAY;
import com.jpexs.asdec.types.MORPHLINESTYLEARRAY;
import com.jpexs.asdec.types.RECT;
import com.jpexs.asdec.types.SHAPE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DefineMorphShapeTag
extends CharacterTag
implements BoundedTag,
AloneTag {
    public int characterId;
    public RECT startBounds;
    public RECT endBounds;
    public MORPHFILLSTYLEARRAY morphFillStyles;
    public MORPHLINESTYLEARRAY morphLineStyles;
    public SHAPE startEdges;
    public SHAPE endEdges;

    @Override
    public int getCharacterID() {
        return this.characterId;
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.characterId);
            sos.writeRECT(this.startBounds);
            sos.writeRECT(this.endBounds);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            SWFOutputStream sos2 = new SWFOutputStream(baos2, version);
            sos2.writeMORPHFILLSTYLEARRAY(this.morphFillStyles, 1);
            sos2.writeMORPHLINESTYLEARRAY(this.morphLineStyles, 1);
            sos2.writeSHAPE(this.startEdges, 1);
            byte[] d = baos2.toByteArray();
            sos.writeUI32(d.length);
            sos.write(d);
            sos.writeSHAPE(this.endEdges, 1);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineMorphShapeTag(byte[] data, int version, long pos) throws IOException {
        super(46, "DefineMorphShape", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.characterId = sis.readUI16();
        this.startBounds = sis.readRECT();
        this.endBounds = sis.readRECT();
        long offset = sis.readUI32();
        this.morphFillStyles = sis.readMORPHFILLSTYLEARRAY();
        this.morphLineStyles = sis.readMORPHLINESTYLEARRAY(1);
        this.startEdges = sis.readSHAPE(1);
        this.endEdges = sis.readSHAPE(1);
    }

    @Override
    public RECT getRect() {
        RECT rect = new RECT();
        rect.Xmin = Math.min(this.startBounds.Xmin, this.endBounds.Xmin);
        rect.Ymin = Math.min(this.startBounds.Ymin, this.endBounds.Ymin);
        rect.Xmax = Math.max(this.startBounds.Xmax, this.endBounds.Xmax);
        rect.Ymax = Math.max(this.startBounds.Ymax, this.endBounds.Ymax);
        return rect;
    }
}

