/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.abc.CopyOutputStream;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.tags.base.Container;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefineSpriteTag
extends CharacterTag
implements Container {
    public int spriteId;
    public int frameCount;
    public List<Tag> subTags;
    private int level;
    static int c = 0;

    @Override
    public int getCharacterID() {
        return this.spriteId;
    }

    public DefineSpriteTag(byte[] data, int version, int level, long pos) throws IOException {
        super(39, "DefineSprite", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version, pos);
        this.spriteId = sis.readUI16();
        this.frameCount = sis.readUI16();
        this.subTags = sis.readTagList(level + 1);
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        if (Main.DISABLE_DANGEROUS) {
            return super.getData(version);
        }
        OutputStream os = baos = new ByteArrayOutputStream();
        if (Main.DEBUG_COPY) {
            os = new CopyOutputStream(os, new ByteArrayInputStream(this.data));
        }
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.spriteId);
            sos.writeUI16(this.frameCount);
            sos.writeTags(this.subTags);
            sos.writeUI16(0);
            sos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    @Override
    public List<Object> getSubItems() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.addAll(this.subTags);
        return ret;
    }

    @Override
    public int getItemCount() {
        return this.subTags.size();
    }

    @Override
    public boolean hasSubTags() {
        return true;
    }

    @Override
    public List<Tag> getSubTags() {
        return this.subTags;
    }

    @Override
    public Set<Integer> getNeededCharacters() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (Tag t : this.subTags) {
            ret.addAll(t.getNeededCharacters());
        }
        return ret;
    }
}

