/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.tags.base.ASMSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DoActionTag
extends Tag
implements ASMSource {
    public byte[] actionBytes;

    public DoActionTag(byte[] data, int version, long pos) {
        super(12, "DoAction", data, pos);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            SWFInputStream sis = new SWFInputStream(bais, version);
            this.actionBytes = sis.readBytes(sis.available());
        }
        catch (IOException e) {
            Logger.getLogger(DoActionTag.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    @Override
    public byte[] getData(int version) {
        return this.actionBytes;
    }

    @Override
    public String getASMSource(int version) {
        List<Action> actions = new ArrayList<Action>();
        try {
            actions = new SWFInputStream(new ByteArrayInputStream(this.actionBytes), version).readActionList();
        }
        catch (IOException ex) {
            Logger.getLogger(DoActionTag.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Action.actionsToString(actions, null, version);
    }

    @Override
    public boolean containsSource() {
        return true;
    }

    @Override
    public String toString() {
        return "DoAction";
    }

    @Override
    public List<Action> getActions(int version) {
        try {
            return new SWFInputStream(new ByteArrayInputStream(this.actionBytes), version).readActionList();
        }
        catch (IOException ex) {
            Logger.getLogger(DoActionTag.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<Action>();
        }
    }

    @Override
    public void setActions(List<Action> actions, int version) {
        this.actionBytes = Action.actionsToBytes(actions, true, version);
    }

    @Override
    public byte[] getActionBytes() {
        return this.actionBytes;
    }

    @Override
    public void setActionBytes(byte[] actionBytes) {
        this.actionBytes = actionBytes;
    }
}

