/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SoundStreamHeadTag
extends Tag {
    public int playBackSoundRate;
    public int playBackSoundSize;
    public int playBackSoundType;
    public int streamSoundCompression;
    public int streamSoundRate;
    public int streamSoundSize;
    public int streamSoundType;
    public int streamSoundSampleCount;
    public int latencySeek;

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUB(4, 0L);
            sos.writeUB(2, this.playBackSoundRate);
            sos.writeUB(1, this.playBackSoundSize);
            sos.writeUB(1, this.playBackSoundType);
            sos.writeUB(4, this.streamSoundCompression);
            sos.writeUB(2, this.streamSoundRate);
            sos.writeUB(1, this.streamSoundSize);
            sos.writeUB(1, this.streamSoundType);
            sos.writeUI16(this.streamSoundSampleCount);
            if (this.streamSoundCompression == 2) {
                sos.writeSI16(this.latencySeek);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public SoundStreamHeadTag(byte[] data, int version, long pos) throws IOException {
        super(18, "SoundStreamHead", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        sis.readUB(4);
        this.playBackSoundRate = (int)sis.readUB(2);
        this.playBackSoundSize = (int)sis.readUB(1);
        this.playBackSoundType = (int)sis.readUB(1);
        this.streamSoundCompression = (int)sis.readUB(4);
        this.streamSoundRate = (int)sis.readUB(2);
        this.streamSoundSize = (int)sis.readUB(1);
        this.streamSoundType = (int)sis.readUB(1);
        this.streamSoundSampleCount = sis.readUI16();
        if (this.streamSoundCompression == 2) {
            this.latencySeek = sis.readSI16();
        }
    }
}

